/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.util;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.utils.AtlasJson;

public class Types {
    private static final String DEFAULT_MAX_STR_LENGTH = "5000";
    public static final String INTERNAL_BM_NAME = "__bmName";

    public static void setDefaultMaxStrLength(AtlasStructDef.AtlasAttributeDef attrDef) {
        if (attrDef == null || !Objects.equals(attrDef.getTypeName(), "string")) {
            return;
        }
        if (attrDef.getOptions() == null) {
            attrDef.setOptions(new HashMap());
        }
        if (!attrDef.getOptions().containsKey("maxStrLength")) {
            attrDef.setOption("maxStrLength", DEFAULT_MAX_STR_LENGTH);
        }
    }

    public static void setDefaultApplicableEntityTypes(AtlasStructDef.AtlasAttributeDef attrDef) {
        Set applicableTypes;
        if (attrDef == null) {
            return;
        }
        if (attrDef.getOptions() == null) {
            attrDef.setOptions(new HashMap());
        }
        if ((applicableTypes = (Set)AtlasJson.fromJson((String)attrDef.getOption("applicableEntityTypes"), Set.class)) == null || applicableTypes.isEmpty()) {
            attrDef.setOption("applicableEntityTypes", "[\"cf_entity\"]");
        }
    }

    public static boolean containsStringIndexType(AtlasBusinessMetadataDef bmDef) {
        List attrDefs = bmDef.getAttributeDefs();
        if (attrDefs == null || attrDefs.isEmpty()) {
            return false;
        }
        for (AtlasStructDef.AtlasAttributeDef attrDef : attrDefs) {
            if (attrDef.getIndexType() != AtlasStructDef.AtlasAttributeDef.IndexType.STRING) continue;
            return true;
        }
        return false;
    }

    public static AtlasStructDef.AtlasAttributeDef createInternalBMNameAttribute() {
        AtlasStructDef.AtlasAttributeDef attrDef = new AtlasStructDef.AtlasAttributeDef(INTERNAL_BM_NAME, "string", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, false, true);
        attrDef.setIsOptional(false);
        attrDef.setIndexType(AtlasStructDef.AtlasAttributeDef.IndexType.DEFAULT);
        attrDef.setOption("maxStrLength", DEFAULT_MAX_STR_LENGTH);
        attrDef.setOption("applicableEntityTypes", "[\"cf_entity\"]");
        return attrDef;
    }
}

