/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.ControllerInternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerRollHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final BeginShutdownControllerHandle beginShutdownControllerHandle;

    public ControllerRollHandler(BeginShutdownControllerHandle beginShutdownControllerHandle) {
        this.beginShutdownControllerHandle = beginShutdownControllerHandle;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.equals("/status")) {
            log.debug("Handling roll status query");
            this.handleRollableQuery(response);
        }
    }

    private void handleRollableQuery(HttpServletResponse response) throws IOException {
        try {
            BeginShutdownControllerStatus status = this.beginShutdownControllerHandle.generateRollableStatus();
            boolean rollable = status.rollable();
            String reason = status.reason();
            StatusResponse statusResponse = new StatusResponse(rollable, reason);
            ResponseContainer.dataResponse(statusResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String failureMessage = "Failed to retrieve and write controller rollable information";
            log.error(failureMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = ControllerRollHandler.genericErrorResponse(failureMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }

    static final class StatusResponse {
        @JsonProperty(value="rollable")
        final boolean rollable;
        @JsonProperty(value="reason")
        final String reason;

        @JsonCreator
        public StatusResponse(@JsonProperty(value="rollable", required=true) boolean rollable, @JsonProperty(value="reason", required=false) String reason) {
            this.rollable = rollable;
            this.reason = reason == null ? "" : reason;
        }

        public String toString() {
            return "StatusResponse{rollable=" + this.rollable + ", reason=" + this.reason + '}';
        }
    }
}

