/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ResponseContainer<T> {
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final DataResponse<T> data;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="errors")
    public final List<ErrorResponse> errors;

    public static ResponseContainer<?> errorResponse(List<ErrorResponse> errors) {
        Objects.requireNonNull(errors, "errors null");
        return new ResponseContainer(null, errors);
    }

    public static <T> ResponseContainer<T> dataResponse(T data) {
        Objects.requireNonNull(data, "data null");
        DataResponse<T> dataResponse = new DataResponse<T>(data);
        return new ResponseContainer<T>(dataResponse, null);
    }

    ResponseContainer(@JsonProperty(value="data") DataResponse<T> data, @JsonProperty(value="errors") List<ErrorResponse> errors) {
        this.data = data;
        this.errors = errors;
    }

    public String toString() {
        return "StatusResponseContainer{data=" + this.data + ", errors=" + this.errors + '}';
    }

    private int statusCode() {
        if (this.errors != null && this.errors.size() > 0) {
            return this.errors.get((int)0).status;
        }
        return 200;
    }

    public void write(ObjectMapper mapper, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.api+json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(this.statusCode());
        try (ServletOutputStream outputStream = response.getOutputStream();){
            mapper.writeValue((OutputStream)outputStream, (Object)this);
            outputStream.flush();
        }
    }

    public static final class DataResponse<T> {
        @JsonProperty(value="attributes")
        public final T attributes;

        DataResponse(@JsonProperty(value="attributes") T attributes) {
            this.attributes = attributes;
        }
    }

    public static final class ErrorResponse {
        @JsonProperty(value="id")
        public final int id;
        @JsonProperty(value="status")
        public final int status;
        @JsonProperty(value="title")
        public final String title;

        public ErrorResponse(@JsonProperty(value="id") int id, @JsonProperty(value="status") int status, @JsonProperty(value="title") String title) {
            this.id = id;
            this.status = status;
            this.title = title;
        }

        public String toString() {
            return "ErrorResponse{id=" + this.id + ", status=" + this.status + ", title='" + this.title + '\'' + '}';
        }
    }
}

