/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.KafkaRestoreRestApiReturnStatus;
import io.confluent.rest.ResponseContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final KafkaRestorePartitionHandle kafkaRestorePartitionHandle;
    private static final int BUFFER_SIZE = 4096;

    public RestoreHandler(KafkaRestorePartitionHandle restoreHandle) {
        this.kafkaRestorePartitionHandle = restoreHandle;
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.equals("/leader-replica")) {
            log.debug("Handling leader-replica query");
            this.handleLeaderReplicaQuery(request, response);
        } else if (target.equals("/tier-state")) {
            log.debug("Handling tier state query");
            this.handleTierStateQuery(request, response);
        } else if (target.equals("/ftps")) {
            log.debug("Handling download of ftps file");
            this.handleFtpsDownload(request, response);
        } else if (target.equals("/fence")) {
            log.debug("Handling fence tier partition state");
            this.handleFenceTierPartitionState(request, response);
        } else if (target.equals("/restore")) {
            log.debug("Handling force restore of tier state");
            this.handleRestoreTierPartitionState(request, response);
        } else if (target.equals("/unfreeze")) {
            log.debug("Handling force restore of tier state");
            this.handleUnfreezeTierPartition(request, response);
        } else if (target.equals("/validate-log-range")) {
            log.debug("Handling validate log range");
            this.handleValidateLogRange(request, response);
        }
    }

    private void handleLeaderReplicaQuery(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            LeaderReplicaRequest leaderReplicaRequest = (LeaderReplicaRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, LeaderReplicaRequest.class);
            int brokerId = this.kafkaRestorePartitionHandle.leaderReplica(leaderReplicaRequest.topicName, leaderReplicaRequest.partition);
            if (brokerId == KafkaRestoreRestApiReturnStatus.invalid) {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve leader for partition");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            } else {
                LeaderReplicaResponse leaderReplicaResponse = new LeaderReplicaResponse(brokerId);
                ResponseContainer.dataResponse(leaderReplicaResponse).write(OBJECT_MAPPER, response);
            }
            ResponseContainer.dataResponse(brokerId).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve leader for partition";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleTierStateQuery(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            TierPartitionStatusRequest tierPartitionStateRequest = (TierPartitionStatusRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, TierPartitionStatusRequest.class);
            long status = this.kafkaRestorePartitionHandle.tierPartitionStatus(tierPartitionStateRequest.topicName, tierPartitionStateRequest.partition);
            if (status == (long)KafkaRestoreRestApiReturnStatus.invalid) {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve and write tier partition status");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            } else {
                TierPartitionStateResponse statusResponse = new TierPartitionStateResponse(status);
                ResponseContainer.dataResponse(statusResponse).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve tier partition state for partition";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleFtpsDownload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            FtpsDownloadRequest ftpsDownloadRequest = (FtpsDownloadRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, FtpsDownloadRequest.class);
            log.debug(String.format("input request: %s", ftpsDownloadRequest));
            Optional<File> ftpsFile = this.kafkaRestorePartitionHandle.ftpsFile(ftpsDownloadRequest.topicName, ftpsDownloadRequest.partition);
            if (!ftpsFile.isPresent()) {
                String errorMessage = String.format("Ftps file not found for partition: %s", ftpsDownloadRequest);
                log.error(errorMessage);
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
                return;
            }
            response.setContentType("application/octet-stream");
            response.setContentLength((int)ftpsFile.get().length());
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", ftpsFile.get().getName()));
            try (FileInputStream in = new FileInputStream(ftpsFile.get());
                 ServletOutputStream out = response.getOutputStream();){
                int numBytesRead;
                byte[] buffer = new byte[4096];
                while ((numBytesRead = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, numBytesRead);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to handle ftps file download";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleFenceTierPartitionState(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            TierPartitionFenceRequest tierPartitionFenceRequest = (TierPartitionFenceRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, TierPartitionFenceRequest.class);
            int status = this.kafkaRestorePartitionHandle.setFenceTierTopicPartition(tierPartitionFenceRequest.topicName, tierPartitionFenceRequest.partition);
            if (status == KafkaRestoreRestApiReturnStatus.success) {
                TierPartitionStateSetResponse cmdResponse = new TierPartitionStateSetResponse(status);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve and write tier partition status");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to send fence tier partition state event for partition";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleRestoreTierPartitionState(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            TierPartitionRestoreRequest tierPartitionRestoreRequest = (TierPartitionRestoreRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, TierPartitionRestoreRequest.class);
            int status = this.kafkaRestorePartitionHandle.setForceRestoreTierPartition(tierPartitionRestoreRequest.topicName, tierPartitionRestoreRequest.partition, tierPartitionRestoreRequest.logStartOffset, tierPartitionRestoreRequest.logEndOffset, tierPartitionRestoreRequest.contentHash);
            if (status == KafkaRestoreRestApiReturnStatus.success) {
                TierPartitionStateSetResponse cmdResponse = new TierPartitionStateSetResponse(status);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve and write tier partition status");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to send fence tier partition state event for partition";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleUnfreezeTierPartition(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            TierPartitionUnfreezeRequest tierPartitionUnfreezeRequest = (TierPartitionUnfreezeRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, TierPartitionUnfreezeRequest.class);
            int status = this.kafkaRestorePartitionHandle.setUnfreezeLogStartOffset(tierPartitionUnfreezeRequest.topicName, tierPartitionUnfreezeRequest.partition);
            if (status == KafkaRestoreRestApiReturnStatus.success) {
                TierPartitionStateSetResponse cmdResponse = new TierPartitionStateSetResponse(status);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve and write tier partition status");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to send fence tier partition state event for partition";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private void handleValidateLogRange(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ValidateLogRangeRequest validateLogRangeRequest = (ValidateLogRangeRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, ValidateLogRangeRequest.class);
            int status = this.kafkaRestorePartitionHandle.validateLogRange(validateLogRangeRequest.topicName, validateLogRangeRequest.partition, validateLogRangeRequest.logStartOffset, validateLogRangeRequest.logEndOffset);
            if (status == KafkaRestoreRestApiReturnStatus.success) {
                TierPartitionStateSetResponse cmdResponse = new TierPartitionStateSetResponse(status);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse("Failed to retrieve and write tier partition status");
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to validate log range";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = RestoreHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    static final class ValidateLogRangeRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;
        @JsonProperty(value="log_start_offset")
        final long logStartOffset;
        @JsonProperty(value="log_end_offset")
        final long logEndOffset;

        @JsonCreator
        public ValidateLogRangeRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition, @JsonProperty(value="log_start_offset", required=true) long logStartOffset, @JsonProperty(value="log_end_offset", required=true) long logEndOffset) {
            this.topicName = topicName;
            this.partition = partition;
            this.logStartOffset = logStartOffset;
            this.logEndOffset = logEndOffset;
        }

        public String toString() {
            return "ValidateLogRangeRequest{topic_name=" + this.topicName + ", partition=" + this.partition + ", log_start_offset=" + this.logStartOffset + ", log_end_offset=" + this.logEndOffset + '}';
        }
    }

    static final class TierPartitionUnfreezeRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public TierPartitionUnfreezeRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "TierPartitionUnfreezeRequest{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }

    static final class TierPartitionRestoreRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;
        @JsonProperty(value="log_start_offset")
        final long logStartOffset;
        @JsonProperty(value="log_end_offset")
        final long logEndOffset;
        @JsonProperty(value="content_hash")
        final String contentHash;

        @JsonCreator
        public TierPartitionRestoreRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition, @JsonProperty(value="log_start_offset", required=true) long logStartOffset, @JsonProperty(value="log_end_offset", required=true) long logEndOffset, @JsonProperty(value="content_hash", required=true) String contentHash) {
            this.topicName = topicName;
            this.partition = partition;
            this.contentHash = contentHash;
            this.logStartOffset = logStartOffset;
            this.logEndOffset = logEndOffset;
        }

        public String toString() {
            return "TierPartitionRestoreRequest{topic_name=" + this.topicName + ", partition=" + this.partition + ", log_start_offset=" + this.logStartOffset + ", log_end_offset=" + this.logEndOffset + ", content_hash=" + this.contentHash + '}';
        }
    }

    static final class TierPartitionFenceRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public TierPartitionFenceRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "TierPartitionFence{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }

    static final class FtpsDownloadRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public FtpsDownloadRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "FtpsDownloadRequest{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }

    static final class TierPartitionStateSetResponse {
        @JsonProperty(value="response")
        final int response;

        @JsonCreator
        public TierPartitionStateSetResponse(@JsonProperty(value="response", required=true) int response) {
            this.response = response;
        }

        public String toString() {
            return "TierPartitionStateSetResponse{response=" + this.response + '}';
        }
    }

    static final class TierPartitionStateResponse {
        @JsonProperty(value="state")
        final long tierPartitionState;

        @JsonCreator
        public TierPartitionStateResponse(@JsonProperty(value="state", required=true) long tierPartitionState) {
            this.tierPartitionState = tierPartitionState;
        }

        public String toString() {
            return "TierPartitionStateResponse{state=" + this.tierPartitionState + '}';
        }
    }

    static final class TierPartitionStatusRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public TierPartitionStatusRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "TierPartitionStateRequest{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }

    static final class LeaderReplicaResponse {
        @JsonProperty(value="broker")
        final int broker;

        @JsonCreator
        public LeaderReplicaResponse(@JsonProperty(value="broker", required=true) int broker) {
            this.broker = broker;
        }

        public String toString() {
            return "LeaderReplicaResponse{broker=" + this.broker + '}';
        }
    }

    static final class LeaderReplicaRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public LeaderReplicaRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "LeaderReplicaRequest{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }
}

