/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.AuditJobHandler;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.BrokerStartupStatusHandle;
import io.confluent.rest.BrokerStartupStatusHandler;
import io.confluent.rest.ForceRollSegmentsHandle;
import io.confluent.rest.ForceRollSegmentsHandler;
import io.confluent.rest.InternalRestServerConfig;
import io.confluent.rest.InternalRestServerSSL;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.RestoreHandler;
import io.confluent.rest.RollHandler;
import io.confluent.rest.TierMetadataRecoveryHandle;
import io.confluent.rest.TierMetadataRecoveryHandler;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.FileWatchService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalRestServer {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private static final FileWatchService FILE_STORE_WATCH_SERVICE = new FileWatchService();
    private static final long CONNECTION_IDLE_TIMEOUT_MS = Duration.ofMinutes(1L).toMillis();
    private static final int CONNECTOR_IDLE_TIMEOUT = 60000;
    private final BeginShutdownBrokerHandle beginShutdownBrokerHandle;
    private final KafkaRestorePartitionHandle kafkaRestorePartitionHandle;
    private final AuditJobHandle auditJobHandle;
    private final TierMetadataRecoveryHandle tierMetadataRecoveryHandle;
    private final ForceRollSegmentsHandle forceRollSegmentsHandle;
    private final BrokerStartupStatusHandle brokerStartupStatusHandle;
    private final int port;
    private final InternalRestServerConfig config;
    private final boolean sslEnabled;
    private Server server;
    private FileStoreWatchListener keyStoreFileWatchListener;
    private FileStoreWatchListener trustStoreFileWatchListener;

    public InternalRestServer(Map<?, ?> originals, BeginShutdownBrokerHandle beginShutdownBrokerHandle, KafkaRestorePartitionHandle kafkaRestorePartitionHandle, AuditJobHandle auditJobHandle, TierMetadataRecoveryHandle tierMetadataRecoveryHandle, ForceRollSegmentsHandle forceRollSegmentsHandle, BrokerStartupStatusHandle brokerStartupStatusHandle) {
        this.config = new InternalRestServerConfig(originals);
        this.port = this.config.getInt("confluent.internal.rest.server.bind.port");
        this.sslEnabled = this.config.getBoolean("confluent.internal.rest.server.ssl.enable");
        this.beginShutdownBrokerHandle = Objects.requireNonNull(beginShutdownBrokerHandle, "null beginShutdownBrokerHandle");
        this.kafkaRestorePartitionHandle = Objects.requireNonNull(kafkaRestorePartitionHandle, "null kafkaRestorePartitionHandle");
        this.auditJobHandle = Objects.requireNonNull(auditJobHandle, "null auditJobHandle");
        this.tierMetadataRecoveryHandle = Objects.requireNonNull(tierMetadataRecoveryHandle, "null tierMetadataRecoveryHandle");
        this.forceRollSegmentsHandle = Objects.requireNonNull(forceRollSegmentsHandle, "null forceRollSegmentsHandle");
        this.brokerStartupStatusHandle = brokerStartupStatusHandle;
    }

    private ServerConnector configureConnector(int connectorPort, boolean useSsl) {
        ServerConnector connector;
        if (useSsl) {
            log.info("Setting InternalRestServer SSL configurations" + this.config.printSslConfigs());
            SslContextFactory.Server ssl = InternalRestServerSSL.createServerSideSslContextFactory(this.config, "confluent.internal.rest.server.");
            connector = new ServerConnector(this.server, ssl);
        } else {
            connector = new ServerConnector(this.server);
        }
        connector.setIdleTimeout(60000L);
        connector.setPort(connectorPort);
        return connector;
    }

    public InternalRestServerConfig getConfigs() {
        return this.config;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("Server is already running.");
        }
        this.server = new Server();
        ServerConnector connector = this.configureConnector(this.port, this.sslEnabled);
        if (this.sslEnabled) {
            this.registerSSLStoreFileWatchListeners();
        }
        log.info("Binding to port {}", (Object)connector.getPort());
        this.server.addConnector((Connector)connector);
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(this.createContextHandler("/v1/roll", new RollHandler(this.beginShutdownBrokerHandle)));
        handlers.add(this.createContextHandler("/v1/restore", new RestoreHandler(this.kafkaRestorePartitionHandle)));
        handlers.add(this.createContextHandler("/v1/audit", new AuditJobHandler(this.auditJobHandle)));
        handlers.add(this.createContextHandler("/v1/tiermetadata", new TierMetadataRecoveryHandler(this.tierMetadataRecoveryHandle, (long)((double)CONNECTION_IDLE_TIMEOUT_MS * 0.75))));
        handlers.add(this.createContextHandler("/v1/tiertools", new ForceRollSegmentsHandler(this.forceRollSegmentsHandle)));
        if (this.brokerStartupStatusHandle != null) {
            handlers.add(this.createContextHandler("/v1/startup", new BrokerStartupStatusHandler(this.brokerStartupStatusHandle)));
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.add(new DefaultHandler());
        contexts.setHandlers(handlers.toArray(new Handler[0]));
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    private ContextHandler createContextHandler(String contextPath, Handler.Abstract handler) {
        ContextHandler contextHandler = new ContextHandler(contextPath);
        contextHandler.setContextPath(contextPath);
        contextHandler.setHandler((Handler)handler);
        return contextHandler;
    }

    FileStoreWatchListener keyStoreFileWatchListener() {
        return this.keyStoreFileWatchListener;
    }

    FileStoreWatchListener trustStoreFileWatchListener() {
        return this.trustStoreFileWatchListener;
    }

    private void reloadKeystoreCerts() {
        this.reloadSSLCerts(true);
    }

    private void reloadTruststoreCerts() {
        this.reloadSSLCerts(false);
    }

    private Optional<SslContextFactory> getSSLFactory(Connector connector) {
        if (!(connector instanceof ServerConnector)) {
            return Optional.empty();
        }
        ServerConnector serverConnector = (ServerConnector)connector;
        SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
        if (sslConnectionFactory == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(sslConnectionFactory.getSslContextFactory());
    }

    boolean isKeyStoreConfigured() {
        return Arrays.stream(this.server.getConnectors()).anyMatch(connector -> this.getSSLFactory((Connector)connector).isPresent() && this.getSSLFactory((Connector)connector).get().getKeyStore() != null);
    }

    private void reloadSSLCerts(boolean isKeystore) {
        Map sslConfigValues = this.config.valuesWithPrefixAllOrNothing("confluent.internal.rest.server.");
        String securityProviders = this.config.getString("security.providers");
        boolean useBcfksStore = InternalRestServerSSL.useBcfks(sslConfigValues, securityProviders);
        for (Connector connector : this.server.getConnectors()) {
            Optional<SslContextFactory> sslContextFactory = this.getSSLFactory(connector);
            if (!sslContextFactory.isPresent()) continue;
            try {
                InternalRestServerSSL.setSecurityStoreProps(sslContextFactory.get(), sslConfigValues, isKeystore, useBcfksStore, true);
                sslContextFactory.get().reload(factory -> log.info("Reloaded ssl factory for the connector " + connector.getName()));
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new InvalidConfigurationException("Failed to load SSL keystore ", (Throwable)e);
            }
        }
    }

    private void registerSSLStoreFileWatchListeners() {
        if (!this.config.getBoolean("confluent.ssl.enable.dynamic.store.update").booleanValue()) {
            return;
        }
        Map sslConfigValues = this.config.valuesWithPrefixAllOrNothing("confluent.internal.rest.server.");
        String keyStoreLocation = sslConfigValues.getOrDefault("ssl.keystore.location", null);
        String trustStoreLocation = sslConfigValues.getOrDefault("ssl.truststore.location", null);
        if (keyStoreLocation != null) {
            this.keyStoreFileWatchListener = new FileStoreWatchListener(keyStoreLocation, this::reloadKeystoreCerts);
            FILE_STORE_WATCH_SERVICE.add((FileWatchService.Listener)this.keyStoreFileWatchListener);
            log.info("Enabled ssl.enable.dynamic.store.update for keystore ");
        }
        if (trustStoreLocation != null) {
            this.trustStoreFileWatchListener = new FileStoreWatchListener(trustStoreLocation, this::reloadTruststoreCerts);
            FILE_STORE_WATCH_SERVICE.add((FileWatchService.Listener)this.trustStoreFileWatchListener);
            log.info("Enabled ssl.enable.dynamic.store.update for truststore");
        }
    }

    private void removeFileWatcherListener() {
        if (this.keyStoreFileWatchListener != null) {
            FILE_STORE_WATCH_SERVICE.remove((FileWatchService.Listener)this.keyStoreFileWatchListener);
        }
        if (this.trustStoreFileWatchListener != null) {
            FILE_STORE_WATCH_SERVICE.remove((FileWatchService.Listener)this.trustStoreFileWatchListener);
        }
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running.");
        }
        log.info("Stopping");
        this.server.stop();
        this.server.join();
        this.server = null;
        this.removeFileWatcherListener();
    }

    class FileStoreWatchListener
    implements FileWatchService.Listener {
        private final AtomicReference<Exception> lastLoadFailure = new AtomicReference<Object>(null);
        private final File watchFile;
        private final Runnable reloadSSLContext;
        private boolean initCompleted;

        public FileStoreWatchListener(String secretStoreLocation, Runnable reloadSSLContext) {
            Path filePath = Paths.get(secretStoreLocation, new String[0]);
            this.watchFile = filePath.toFile();
            this.reloadSSLContext = reloadSSLContext;
        }

        public File file() {
            return this.watchFile;
        }

        public void onInit() {
            this.initCompleted = true;
        }

        public void onUpdate() {
            try {
                this.reloadSSLContext.run();
                this.lastLoadFailure.set(null);
            }
            catch (Exception e) {
                this.lastLoadFailure.set(e);
                log.error("Error while reloading the security store", (Throwable)e);
            }
        }

        Exception lastLoadFailure() {
            return this.lastLoadFailure.get();
        }

        boolean initCompleted() {
            return this.initCompleted;
        }
    }
}

