/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TierTopicHeadDataLossDetectionResponse {
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    @JsonProperty(value="data_loss_report_path")
    final String dataLossReportPath;
    @JsonProperty(value="completion_status")
    final CompletionStatus completionStatus;
    @JsonProperty(value="error_messages")
    final List<String> errorMessages;

    @JsonCreator
    public TierTopicHeadDataLossDetectionResponse(@JsonProperty(value="data_loss_report_path", required=true) String dataLossReportPath, @JsonProperty(value="completion_status", required=true) CompletionStatus completionStatus, @JsonProperty(value="error_messages") List<String> errorMessages) {
        this.dataLossReportPath = dataLossReportPath;
        this.completionStatus = completionStatus;
        this.errorMessages = errorMessages;
    }

    @JsonProperty(value="data_loss_report_path", required=true)
    public String dataLossReportPath() {
        return this.dataLossReportPath;
    }

    @JsonProperty(value="completion_status", required=true)
    public CompletionStatus completionStatus() {
        return this.completionStatus;
    }

    @JsonProperty(value="error_messages", required=true)
    public List<String> errorMessages() {
        return this.errorMessages;
    }

    public String toString() {
        return String.format("TierTopicHeadDataLossDetectionResponse{dataLossReportPath=%s, completionStatus=%s, errorMessages=[%s]}", new Object[]{this.dataLossReportPath, this.completionStatus, this.errorMessages});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicHeadDataLossDetectionResponse that = (TierTopicHeadDataLossDetectionResponse)o;
        return Objects.equals(this.dataLossReportPath, that.dataLossReportPath) && this.completionStatus == that.completionStatus && Objects.equals(this.errorMessages, that.errorMessages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataLossReportPath, this.completionStatus, this.errorMessages});
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addKeySerializer(CompletionStatus.class, (JsonSerializer)new JsonSerializer<CompletionStatus>(){

            public void serialize(CompletionStatus value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeFieldName(value.toString());
            }
        });
        module.addKeyDeserializer(CompletionStatus.class, new KeyDeserializer(){

            public Object deserializeKey(String key, DeserializationContext ctxt) {
                return CompletionStatus.fromStringOrThrow(key);
            }
        });
        JSON_SERDE.registerModule((Module)module);
        JSON_SERDE.registerModule((Module)new Jdk8Module());
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    public static enum CompletionStatus {
        SUCCESS,
        PARTIAL_SUCCESS,
        FAILURE;

        private static final Map<String, CompletionStatus> STR_ENUM_MAP;

        public static CompletionStatus fromStringOrThrow(String completionStatusStr) {
            CompletionStatus completionStatus = STR_ENUM_MAP.get(completionStatusStr);
            if (completionStatus == null) {
                throw new IllegalArgumentException("Invalid CompletionStatus: " + completionStatusStr);
            }
            return completionStatus;
        }

        static {
            STR_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(CompletionStatus.values()).collect(Collectors.toMap(Enum::toString, Function.identity())));
        }
    }
}

