/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public abstract class AbstractTokenLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private boolean configured = false;
    static final String LOGIN_SERVER_OPTION = "metadataServerUrls";
    static final String TOKEN_OPTION = "authenticationToken";
    static final String USER_OPTION = "username";
    static final String PASSWORD_OPTION = "password";

    public abstract void configure(Map<String, ?> var1);

    abstract void attachAuthToken(OAuthBearerTokenCallback var1);

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        Map<String, String> moduleOptions = this.jaasConfigDef(saslMechanism, jaasConfigEntries);
        String loginServer = moduleOptions.getOrDefault(LOGIN_SERVER_OPTION, "");
        String authenticationToken = moduleOptions.getOrDefault(TOKEN_OPTION, "");
        String user = moduleOptions.getOrDefault(USER_OPTION, "");
        String pass = moduleOptions.getOrDefault(PASSWORD_OPTION, "");
        this.validateHaveCredentials(user, pass, authenticationToken);
        if (loginServer == null || loginServer.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", LOGIN_SERVER_OPTION));
        }
        HashMap loginConfigs = new HashMap(configs);
        loginConfigs.put(LOGIN_SERVER_OPTION, loginServer);
        loginConfigs.put(USER_OPTION, user);
        loginConfigs.put(PASSWORD_OPTION, pass);
        loginConfigs.put(TOKEN_OPTION, authenticationToken);
        loginConfigs.put("confluent.metadata.bootstrap.server.urls", loginServer);
        this.configure(loginConfigs);
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                try {
                    this.attachAuthToken((OAuthBearerTokenCallback)callback);
                    continue;
                }
                catch (KafkaException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
    }

    private Map<String, String> jaasConfigDef(String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        return Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
    }

    private void validateHaveCredentials(String user, String password, String authToken) throws ConfigException {
        if (user.isEmpty() && authToken.isEmpty()) {
            throw new ConfigException("Must supply either a user or token credentials");
        }
        if (!user.isEmpty() && password.isEmpty()) {
            throw new ConfigException("Option username specified with an empty password");
        }
    }
}

