/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwksVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JkuVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyVerificationKeyResolver;
import io.confluent.kafka.security.PemKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class JwtAuthenticatorConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "authenticator.jwt.";
    public static final String JKU_JWKS = "jku";
    public static final String HTTPS_JWKS = "https";
    public static final String JWKS_PEMFILE = "pemfile";
    private CloseableVerificationKeyResolver keyResolver;
    private static final String MISSING_REQUIRED = "Missing required configuration %s which has no default value.";
    private static final String INVALID_VALUE = "Invalid value for %s.";
    private static final ConfigDef.Validator NON_ZERO_VALIDATOR = ConfigDef.Range.atLeast((Number)1);
    private static final ConfigDef.Validator NON_EMPTY_VALIDATOR = new ConfigDef.NonEmptyString();
    public static final String ISSUER_CONFIG = "issuer";
    static final String ISSUER_DEFAULT = "Confluent";
    protected static final String ISSUER_DOC = "JWT Authentication token issuer.";
    public static final String AUDIENCE_CONFIG = "audience";
    static final String AUDIENCE_DEFAULT = "";
    protected static final String AUDIENCE_DOC = "Identifies the recipients a token is intended for. If configured, tokens must have an entry matching this value in their aud claim. By default tokens with an audience claim present will be rejected.";
    public static final String KEY_RESOLVER_CONFIG = "verificationKeyResolver";
    static final String KEY_RESOLVER_DEFAULT = "pemfile";
    protected static final String KEY_RESOLVER_DOC = "";
    private static final ConfigDef.Validator KEY_RESOLVER_VALIDATOR = ConfigDef.CaseInsensitiveValidString.in((String[])new String[]{"jku", "https", "pemfile"});
    public static final String JKU_KEY_RESOLVER_WHITELIST_CONFIG = "jkuDomainWhiteList";
    static final String JKU_KEY_RESOLVER_WHITELIST_DEFAULT = "";
    protected static final String JKU_KEY_RESOLVER_WHITELIST_DOC = "List of acceptable token provider domains. Domains may be absolute such as auth.myprovider.com, or relative such as .myprovider.com";
    public static final String ALLOW_UNSAFE_KEY_RESOLVER_URL_CONFIG = "allowUnsafeURL";
    static final boolean ALLOW_UNSAFE_KEY_RESOLVER_URL_DEFAULT = false;
    protected static final String ALLOW_UNSAFE_KEY_RESOLVER_URL_DOC = "WARNING: This is for development purpose only and should not be used in production! Allow verification key resolver to use HTTP instead of HTTPS.";
    public static final String JWKS_LOCATION_CONFIG = "jwksLocation";
    static final String JWKS_LOCATION_DEFAULT = "";
    protected static final String JWKS_LOCATION_DOC = String.format("Location of JsonWebKey information, format is contingent on configured key resolver. pemFile: This may be a single pem encoded file or a directory containing multiple. https: HTTPS url, HTTP may be used for development purposes. See also %s. jku: See %s for JKU configuration details ", "allowUnsafeURL", "jkuDomainWhiteList");
    public static final String VERIFICATION_KEY_REFRESH_INTERVAL_MS_CONFIG = "verificationKeyRefreshInterval";
    static final long VERIFICATION_KEY_REFRESH_INTERVAL_MS_DEFAULT = 3600000L;
    protected static final String VERIFICATION_KEY_REFRESH_INTERVAL_MS_DOC = "Frequency with which to update the key cache. This is only applicable for the https key resolver";
    private static final ConfigDef CONFIG = new ConfigDef().define("issuer", ConfigDef.Type.STRING, (Object)"Confluent", NON_EMPTY_VALIDATOR, ConfigDef.Importance.LOW, "JWT Authentication token issuer.").define("audience", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Identifies the recipients a token is intended for. If configured, tokens must have an entry matching this value in their aud claim. By default tokens with an audience claim present will be rejected.").define("verificationKeyResolver", ConfigDef.Type.STRING, (Object)"pemfile", KEY_RESOLVER_VALIDATOR, ConfigDef.Importance.LOW, "").define("jwksLocation", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, JWKS_LOCATION_DOC).define("jkuDomainWhiteList", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "List of acceptable token provider domains. Domains may be absolute such as auth.myprovider.com, or relative such as .myprovider.com").define("allowUnsafeURL", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "WARNING: This is for development purpose only and should not be used in production! Allow verification key resolver to use HTTP instead of HTTPS.").define("verificationKeyRefreshInterval", ConfigDef.Type.LONG, (Object)3600000L, NON_ZERO_VALIDATOR, ConfigDef.Importance.LOW, "Frequency with which to update the key cache. This is only applicable for the https key resolver");

    public JwtAuthenticatorConfig(Map<String, ?> originals) {
        super(CONFIG, originals);
        this.postValidation();
    }

    public JwtAuthenticatorConfig(String prefix, Map<String, ?> originals) {
        this(JwtAuthenticatorConfig.stripPrefix(prefix, originals));
    }

    public String issuer() {
        return this.getString(ISSUER_CONFIG);
    }

    public CloseableVerificationKeyResolver verificationKeyResolver() {
        return this.keyResolver;
    }

    public String audience() {
        return this.getString(AUDIENCE_CONFIG);
    }

    private static Map<String, ?> stripPrefix(String prefix, Map<String, ?> originals) {
        return originals.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
    }

    private void postValidation() {
        String jwksResolver;
        switch (jwksResolver = this.getString(KEY_RESOLVER_CONFIG).toLowerCase(Locale.ENGLISH)) {
            case "jku": {
                this.keyResolver = JwtAuthenticatorConfig.jkuKeyResolver(this);
                break;
            }
            case "https": {
                this.keyResolver = JwtAuthenticatorConfig.httpsKeyResolver(this);
                break;
            }
            case "pemfile": {
                this.keyResolver = JwtAuthenticatorConfig.pemFileKeyResolver(this);
            }
        }
    }

    private static CloseableVerificationKeyResolver pemFileKeyResolver(JwtAuthenticatorConfig config) {
        String publicKeyPath = config.getString(JWKS_LOCATION_CONFIG);
        Collection<Object> publicKeys = Collections.emptyList();
        if (publicKeyPath == null || publicKeyPath.isEmpty()) {
            JwtAuthenticatorConfig.failValidation(MISSING_REQUIRED, JWKS_LOCATION_CONFIG);
        }
        try {
            publicKeys = JwtAuthenticatorConfig.loadPublicKeys(publicKeyPath);
        }
        catch (IOException e) {
            JwtAuthenticatorConfig.failValidation(e, INVALID_VALUE, JWKS_LOCATION_CONFIG, e.getMessage());
        }
        if (publicKeys.isEmpty()) {
            throw new ConfigException("No files with pem extension found on path " + publicKeyPath);
        }
        return new PublicKeyVerificationKeyResolver(new PublicKeyJwks(publicKeys));
    }

    private static CloseableVerificationKeyResolver httpsKeyResolver(JwtAuthenticatorConfig config) {
        String httpsKeyResolverURL = config.getString(JWKS_LOCATION_CONFIG);
        boolean unsafeAllowed = config.getBoolean(ALLOW_UNSAFE_KEY_RESOLVER_URL_CONFIG);
        if (httpsKeyResolverURL == null || httpsKeyResolverURL.isEmpty()) {
            JwtAuthenticatorConfig.failValidation(MISSING_REQUIRED, JWKS_LOCATION_CONFIG);
        }
        AsyncHttpsJwks httpsJwks = new AsyncHttpsJwks(httpsKeyResolverURL, unsafeAllowed, 3600000L);
        return new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
    }

    private static CloseableVerificationKeyResolver jkuKeyResolver(JwtAuthenticatorConfig config) {
        List domainWhitelist = config.getList(JKU_KEY_RESOLVER_WHITELIST_CONFIG);
        boolean unsafeAllowed = config.getBoolean(ALLOW_UNSAFE_KEY_RESOLVER_URL_CONFIG);
        if (domainWhitelist == null || domainWhitelist.isEmpty()) {
            JwtAuthenticatorConfig.failValidation(MISSING_REQUIRED, JKU_KEY_RESOLVER_WHITELIST_CONFIG);
        }
        return new JkuVerificationKeyResolver(domainWhitelist, unsafeAllowed);
    }

    private static Collection<PublicKey> loadPublicKeys(String pemLocation) throws IOException {
        return JwtAuthenticatorConfig.getPemPaths(Paths.get(pemLocation, new String[0])).stream().map(PemKey::readPublicKey).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static List<Path> getPemPaths(Path pemPath) throws IOException {
        if (Files.isRegularFile(pemPath, new LinkOption[0])) {
            return Collections.singletonList(pemPath);
        }
        ArrayList<Path> keys = new ArrayList<Path>();
        Files.newDirectoryStream(pemPath, "*.pem").forEach(keys::add);
        return keys;
    }

    private static void failValidation(String template, Object ... args) {
        throw new ConfigException(String.format(template, args));
    }

    private static void failValidation(Exception e, String template, Object ... args) {
        throw new ConfigException(String.format(template, args), (Object)e);
    }
}

