/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnverifiedJwtBearerToken
implements OAuthBearerToken {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String value;
    private final JwtClaims jwtClaims;
    private final String principalName;
    private final Set<String> scope;
    private final long lifetimeMs;
    private final Long startTimeMs;

    public UnverifiedJwtBearerToken(String value) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipAllDefaultValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        try {
            this.jwtClaims = jwtConsumer.processToClaims(value);
            this.value = value;
            this.principalName = this.jwtClaims.getSubject();
            this.scope = Collections.unmodifiableSet(new HashSet(this.jwtClaims.getStringListClaimValue("scope")));
            this.lifetimeMs = this.jwtClaims.getExpirationTime().getValueInMillis();
            this.startTimeMs = this.jwtClaims.getIssuedAt().getValueInMillis();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new ConfigException("Failed to construct JwtBearerToken", (Object)e);
        }
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        return this.scope;
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return this.principalName;
    }

    public Long startTimeMs() {
        return this.startTimeMs;
    }

    public <T> Optional<T> claim(String claim, Class<T> claimType) {
        try {
            return Optional.of(this.jwtClaims.getClaimValue(claim, claimType));
        }
        catch (MalformedClaimException e) {
            this.log.error("Failed to retrieve claim " + claim, (Throwable)e);
            return Optional.empty();
        }
    }
}

