/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.config.provider;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptionEngine {
    public static final int GCM_TAG_LENGTH = 128;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private byte[] dataEncryptionKey;
    private String masterKey;
    private int dataKeyLength;
    public static final Pattern CIPHER_PATTERN = Pattern.compile("ENC\\[(.*?),data:(.*?),iv:(.*?),type:(.*?)(.*?)\\]");

    public DecryptionEngine(String masterKeyEnvVar, String dataKeyCipher, String keyLength) throws Exception {
        try {
            this.masterKey = this.loadMasterKey(masterKeyEnvVar);
            this.dataEncryptionKey = this.loadDataKey(dataKeyCipher);
            this.dataKeyLength = Integer.parseInt(keyLength);
        }
        catch (Exception e) {
            this.log.error("Failed to initialize the encryption engine");
            throw new ConfigException("Failed to initialize the encryption engine", (Object)e);
        }
    }

    private byte[] base64Decode(String data) throws Exception {
        return Base64.getDecoder().decode(data.getBytes());
    }

    private Key convertByteArrKeyToAESKey(byte[] key) {
        return new SecretKeySpec(key, "AES");
    }

    protected String loadMasterKey(String environmentVariable) {
        String masterKey = System.getenv(environmentVariable);
        if (masterKey == null) {
            this.log.error("Failed to load master key from environment variable.");
            throw new ConfigException("Failed to load master key from environment variable.");
        }
        return masterKey;
    }

    private byte[] loadDataKey(String dataKeyCipher) throws Exception {
        try {
            String dataKeyEnc = this.decryptWithMasterKey(dataKeyCipher);
            return this.base64Decode(dataKeyEnc);
        }
        catch (Exception e) {
            this.log.error("Failed to unwrap the data key", (Throwable)e);
            throw new ConfigException("Failed to unwrap the data key", (Object)e);
        }
    }

    private AlgorithmParameterSpec getAlgorithmSpec(String algorithm, byte[] iv) throws Exception {
        AlgorithmParameterSpec algoSpec;
        switch (algorithm) {
            case "AES/CBC/PKCS5Padding": 
            case "AES/CFB/PKCS5Padding": 
            case "AES/OFB/PKCS5Padding": {
                algoSpec = new IvParameterSpec(iv);
                break;
            }
            case "AES/GCM/NoPadding": {
                algoSpec = new GCMParameterSpec(128, iv);
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Algorithm not supported !!!");
            }
        }
        return algoSpec;
    }

    public String decryptWithMasterKey(String encryptedData) throws Exception {
        byte[] masterKeyByte = this.base64Decode(this.masterKey);
        return this.decrypt(encryptedData, masterKeyByte);
    }

    public String decryptWithDEK(String encryptedData) throws Exception {
        String decrypted = this.decrypt(encryptedData, this.dataEncryptionKey);
        return decrypted;
    }

    private String decrypt(String encryptedData, byte[] key) throws Exception {
        Matcher matcher = CIPHER_PATTERN.matcher(encryptedData);
        if (!matcher.matches()) {
            throw new ConfigException("Invalid cipher.");
        }
        String algo = matcher.group(1);
        String data = matcher.group(2);
        String iv = matcher.group(3);
        Cipher cipher = Cipher.getInstance(algo);
        byte[] byteIv = this.base64Decode(iv);
        Key aesKey = this.convertByteArrKeyToAESKey(key);
        AlgorithmParameterSpec algoSpec = this.getAlgorithmSpec(algo, byteIv);
        cipher.init(2, aesKey, algoSpec);
        byte[] decodeData = this.base64Decode(data);
        return new String(cipher.doFinal(decodeData));
    }
}

