/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.multitenant.oauth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class OAuthBearerJwsToken
implements OAuthBearerToken {
    public static final String OAUTH_NEGOTIATED_LOGICAL_CLUSTER_PROPERTY_KEY = "logicalCluster";
    public static final String USER_RESOURCE_ID_CLAIM = "userResourceId";
    public static final String OAUTH_IDENTITY_POOL_PROPERTY_KEY = "identityPoolId";
    private final String value;
    private final String principalName;
    private final Set<String> scope;
    private final long lifetimeMs;
    private final Long startTimeMs;
    private final Map<String, Object> jwtClaims;
    private final String issuer;

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs) {
        this(value, scope, lifetimeMs, principalName, startTimeMs, null, null);
    }

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs, Map<String, Object> jwtClaims) {
        this.value = value;
        this.principalName = principalName;
        this.scope = scope == null ? Collections.emptySet() : scope;
        this.lifetimeMs = lifetimeMs;
        this.startTimeMs = startTimeMs;
        this.jwtClaims = jwtClaims == null ? Collections.emptyMap() : jwtClaims;
        this.issuer = null;
    }

    public OAuthBearerJwsToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs, Map<String, Object> jwtClaims, String issuer) {
        this.value = value;
        this.principalName = principalName;
        this.scope = scope == null ? Collections.emptySet() : scope;
        this.lifetimeMs = lifetimeMs;
        this.startTimeMs = startTimeMs;
        this.jwtClaims = jwtClaims == null ? Collections.emptyMap() : jwtClaims;
        this.issuer = issuer;
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        return Collections.unmodifiableSet(this.scope);
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return this.principalName;
    }

    public Long startTimeMs() {
        return this.startTimeMs;
    }

    public Map<String, Object> jwtClaims() {
        return this.jwtClaims;
    }

    public String issuer() {
        return this.issuer;
    }
}

