/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.token.AbstractTokenLoginCallbackHandler;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.rest.RestClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public class TokenBearerLoginCallbackHandler
extends AbstractTokenLoginCallbackHandler {
    private RestClient restClient;
    private Map<String, Object> configs;

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = new HashMap(configs);
        this.configs.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BEARER.name());
        String authenticationToken = (String)configs.get("authenticationToken");
        if (authenticationToken.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", "authenticationToken"));
        }
        this.createAndSetRestClient(this.configs, authenticationToken);
    }

    private void createAndSetRestClient(Map<String, Object> configs, String authenticationToken) {
        configs.put("confluent.metadata.token.auth.credential", authenticationToken);
        this.close();
        this.restClient = this.createRestClient(configs);
    }

    protected RestClient createRestClient(Map<String, Object> configs) {
        return new RestClient(configs);
    }

    @Override
    void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        OAuthBearerToken token = this.restClient.login();
        this.createAndSetRestClient(this.configs, token.value());
        callback.token(token);
    }

    @Override
    public void close() {
        this.closeRestClient();
    }

    private void closeRestClient() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

