/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth.internals;

import io.spiffe.exception.JwtSourceException;
import io.spiffe.exception.JwtSvidException;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.svid.jwtsvid.JwtSvid;
import io.spiffe.workloadapi.CachedJwtSource;
import io.spiffe.workloadapi.JwtSource;
import io.spiffe.workloadapi.JwtSourceOptions;
import java.io.IOException;
import java.time.Duration;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireJwtTokenRetriever
implements AccessTokenRetriever {
    private static final Logger log = LoggerFactory.getLogger(SpireJwtTokenRetriever.class);
    private JwtSource jwtSource;
    private String audience;

    public SpireJwtTokenRetriever(String spireAgentEndpoint, String audience) {
        this.audience = audience;
        JwtSourceOptions jwtSourceOptions = JwtSourceOptions.builder().spiffeSocketPath(spireAgentEndpoint).initTimeout(Duration.ofSeconds(5L)).build();
        try {
            this.jwtSource = CachedJwtSource.newSource((JwtSourceOptions)jwtSourceOptions);
        }
        catch (JwtSourceException | SocketEndpointAddressException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public String retrieve() throws IOException {
        JwtSvid jwtSvid;
        try {
            jwtSvid = this.jwtSource.fetchJwtSvid(this.audience, new String[0]);
        }
        catch (JwtSvidException e) {
            throw new RuntimeException(e);
        }
        return jwtSvid.getToken();
    }

    public void close() throws IOException {
        this.jwtSource.close();
    }
}

