/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import java.security.Key;
import java.util.List;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public final class AsyncHttpsJwksVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private final HttpsJwksVerificationKeyResolver delegate;
    private final AsyncHttpsJwks httpsJwks;

    public AsyncHttpsJwksVerificationKeyResolver(AsyncHttpsJwks httpsJwks) {
        this(httpsJwks, true);
    }

    public AsyncHttpsJwksVerificationKeyResolver(AsyncHttpsJwks httpsJwks, boolean disambiguateKey) {
        this.httpsJwks = httpsJwks;
        this.delegate = new HttpsJwksVerificationKeyResolver((HttpsJwks)httpsJwks);
        this.delegate.setDisambiguateWithVerifySignature(disambiguateKey);
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (!this.httpsJwks.isRunning()) {
            throw new IllegalStateException("Attempt to resolve key while KeyResolver is being shut down");
        }
        try {
            return this.delegate.resolveKey(jws, nestingContext);
        }
        catch (NullPointerException e) {
            throw new UnresolvableKeyException("Unable to resolve key", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.httpsJwks.close();
    }
}

