/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth;

import io.confluent.kafka.clients.plugins.auth.oauth.FilteringDnsResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;

public class ClusterLinkHttpAccessTokenRetriever
extends HttpAccessTokenRetriever {
    private final URL tokenEndpointUrl;

    public ClusterLinkHttpAccessTokenRetriever(String clientId, String clientSecret, String scope, SSLSocketFactory sslSocketFactory, String tokenEndpointUrl, long loginRetryBackoffMs, long loginRetryBackoffMaxMs, Integer loginConnectTimeoutMs, Integer loginReadTimeoutMs, boolean urlencodeHeader) {
        super(clientId, clientSecret, scope, sslSocketFactory, tokenEndpointUrl, loginRetryBackoffMs, loginRetryBackoffMaxMs, loginConnectTimeoutMs, loginReadTimeoutMs, urlencodeHeader);
        try {
            this.tokenEndpointUrl = new URL(tokenEndpointUrl);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(String.format("The OAuth token endpoint URL (%s) is malformed: %s", tokenEndpointUrl, e.getMessage()));
        }
    }

    public String retrieve() throws IOException {
        boolean hasViolatingIpAddress;
        try {
            FilteringDnsResolver dnsResolver = new FilteringDnsResolver(true, true, true, Collections.emptyList(), Collections.emptyList());
            hasViolatingIpAddress = dnsResolver.hasViolatingIpAddress(this.tokenEndpointUrl.getHost());
        }
        catch (UnknownHostException e) {
            throw new IOException("Failed to resolve tokenEndpointUrl: " + String.valueOf(this.tokenEndpointUrl) + ": " + String.valueOf(e));
        }
        if (hasViolatingIpAddress) {
            throw new IOException("tokenEndpointUrl: " + String.valueOf(this.tokenEndpointUrl) + " contains invalid IP address");
        }
        return super.retrieve();
    }
}

