/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.token.AbstractTokenLoginCallbackHandler;
import io.confluent.security.auth.client.rest.RestClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public class TokenCertificateLoginCallbackHandler
extends AbstractTokenLoginCallbackHandler {
    private RestClient restClient;

    @Override
    public void configure(Map<String, ?> configs) {
        HashMap<String, Object> tempConfigs = new HashMap<String, Object>(configs);
        this.restClient = this.createRestClient(tempConfigs);
    }

    protected RestClient createRestClient(Map<String, Object> configs) {
        return new RestClient(configs);
    }

    @Override
    void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        callback.token(this.restClient.login());
    }

    @Override
    public void close() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    @Override
    public void validateHaveCredentials(Map<String, String> moduleOptions, Map<String, ?> configs) throws ConfigException {
        String user = moduleOptions.getOrDefault("username", "");
        String password = moduleOptions.getOrDefault("password", "");
        String authenticationToken = moduleOptions.getOrDefault("authenticationToken", "");
        if (!user.isEmpty() || !password.isEmpty()) {
            throw new ConfigException(String.format("%s cannot be configured with %s and %s.", this.getClass().getName(), "username", "password"));
        }
        if (!authenticationToken.isEmpty()) {
            throw new ConfigException(String.format("%s cannot be configured with %s.", this.getClass().getName(), "authenticationToken"));
        }
        if (!configs.containsKey("ssl.keystore.location")) {
            throw new ConfigException(String.format("%s must be configured with %s and other keystore related configs.", this.getClass().getName(), "ssl.keystore.location"));
        }
    }
}

