/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.oauth;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.SerializedJwt;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshingAccessTokenRetriever
implements JwtRetriever {
    private static final double TOKEN_REFRESH_RATE = 0.8;
    private static final Logger log = LoggerFactory.getLogger(RefreshingAccessTokenRetriever.class);
    private JwtRetriever accessTokenRetriever;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private String accessToken;

    public RefreshingAccessTokenRetriever(JwtRetriever accessTokenRetriever) {
        this.accessTokenRetriever = accessTokenRetriever;
    }

    public String retrieve() {
        if (this.accessToken == null || this.isTokenExpired().booleanValue()) {
            try {
                this.accessToken = this.accessTokenRetriever.retrieve();
                this.scheduleTokenRefresh();
            }
            catch (JwtRetrieverException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AuthenticationException("Error while retrieving oauthbearer access token");
            }
        }
        return this.accessToken;
    }

    private void scheduleTokenRefresh() {
        long delayForTokenRefresh = this.getNextTokenRefresh();
        if (delayForTokenRefresh < 0L) {
            log.warn("Token refresh stopped, due to invalid token expiry time");
            return;
        }
        log.debug("scheduling token refresh after delay - {}", (Object)delayForTokenRefresh);
        this.scheduler.schedule(() -> {
            try {
                this.accessToken = this.accessTokenRetriever.retrieve();
                this.scheduleTokenRefresh();
            }
            catch (JwtRetrieverException e) {
                log.warn("Token refresh failed", (Throwable)e);
            }
        }, delayForTokenRefresh, TimeUnit.MILLISECONDS);
    }

    private long getNextTokenRefresh() {
        long expirationTime = this.getTokenExpirySec();
        long currentTime = System.currentTimeMillis();
        long activePeriod = expirationTime * 1000L - currentTime;
        return (long)((double)activePeriod * 0.8);
    }

    private long getTokenExpirySec() {
        Map payload;
        SerializedJwt serializedJwt = new SerializedJwt(this.accessToken);
        try {
            payload = OAuthBearerUnsecuredJws.toMap((String)serializedJwt.getPayload());
        }
        catch (OAuthBearerIllegalTokenException e) {
            throw new JwtValidatorException(String.format("Invalid Token: %s", e.getMessage()), (Throwable)e);
        }
        return ((Number)payload.get("exp")).longValue();
    }

    Boolean isTokenExpired() {
        long expirationTime = this.getTokenExpirySec();
        long currentTime = System.currentTimeMillis();
        return currentTime > expirationTime * 1000L;
    }

    public void close() {
        this.scheduler.shutdown();
    }
}

