/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.provider;

import io.confluent.security.auth.client.provider.BasicAuthCredentialProvider;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;

public class BuiltInAuthProviders {
    public static Set<String> builtInBasicAuthCredentialProviders() {
        return Set.of(BasicAuthCredentialProviders.values()).stream().map(Enum::name).collect(Collectors.toSet());
    }

    public static BasicAuthCredentialProvider loadBasicAuthCredentialProvider(String name) {
        ServiceLoader<BasicAuthCredentialProvider> providers = ServiceLoader.load(BasicAuthCredentialProvider.class, BuiltInAuthProviders.class.getClassLoader());
        for (BasicAuthCredentialProvider provider : providers) {
            if (!provider.providerName().equals(name)) continue;
            return provider;
        }
        throw new ConfigException("BasicAuthCredentialProvider not found for " + name);
    }

    public static Set<String> builtInHttpCredentialProviders() {
        return Set.of(HttpCredentialProviders.values()).stream().map(Enum::name).collect(Collectors.toSet());
    }

    public static HttpCredentialProvider loadHttpCredentialProviders(String name) {
        ServiceLoader<HttpCredentialProvider> providers = ServiceLoader.load(HttpCredentialProvider.class, BasicAuthCredentialProvider.class.getClassLoader());
        for (HttpCredentialProvider provider : providers) {
            if (!provider.getProviderName().equalsIgnoreCase(name)) continue;
            return provider;
        }
        throw new ConfigException("HttpCredentialProvider not found for " + name);
    }

    public static enum BasicAuthCredentialProviders {
        USER_INFO;

    }

    public static enum HttpCredentialProviders {
        BASIC,
        BEARER,
        OAUTHBEARER;

    }
}

