/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.security.authorizer.jackson.KafkaModule;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class JsonMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    public static byte[] toByteArray(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JSON serialization failed for: " + String.valueOf(obj), e);
        }
    }

    public static ByteBuffer toByteBuffer(Object obj) {
        try {
            return ByteBuffer.wrap(OBJECT_MAPPER.writeValueAsBytes(obj));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JSON serialization failed for: " + String.valueOf(obj), e);
        }
    }

    public static <T> T fromByteBuffer(ByteBuffer buffer, Class<T> clazz) {
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JSON deserialization failed for object of class " + String.valueOf(clazz), e);
        }
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(KafkaPrincipal.class, (JsonSerializer)new PrincipalSerializer(KafkaPrincipal.class));
        simpleModule.addDeserializer(KafkaPrincipal.class, (JsonDeserializer)new PrincipalDeserializer(KafkaPrincipal.class));
        simpleModule.addSerializer(ResourceType.class, (JsonSerializer)new ResourceTypeSerializer(ResourceType.class));
        simpleModule.addDeserializer(ResourceType.class, (JsonDeserializer)new ResourceTypeDeserializer(ResourceType.class));
        simpleModule.addSerializer(Operation.class, (JsonSerializer)new OperationSerializer(Operation.class));
        simpleModule.addDeserializer(Operation.class, (JsonDeserializer)new OperationDeserializer(Operation.class));
        simpleModule.addSerializer(Uuid.class, (JsonSerializer)new UuidSerializer(Uuid.class));
        simpleModule.addDeserializer(Uuid.class, (JsonDeserializer)new UuidDeserializer(Uuid.class));
        simpleModule.addSerializer(JsonWebKey.class, (JsonSerializer)new JwkJsonSerializer(JsonWebKey.class));
        simpleModule.addDeserializer(JsonWebKey.class, (JsonDeserializer)new JwkJsonDeserializer(JsonWebKey.class));
        simpleModule.addDeserializer(JsonWebKeySet.class, (JsonDeserializer)new JwksJsonDeserializer(JsonWebKeySet.class));
        OBJECT_MAPPER.registerModule((Module)simpleModule);
        OBJECT_MAPPER.registerModule((Module)new KafkaModule());
    }

    private static class PrincipalSerializer
    extends StdSerializer<KafkaPrincipal> {
        public PrincipalSerializer(Class<KafkaPrincipal> t) {
            super(t);
        }

        public void serialize(KafkaPrincipal principal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(principal.toString());
        }
    }

    private static class PrincipalDeserializer
    extends StdDeserializer<KafkaPrincipal> {
        public PrincipalDeserializer(Class<KafkaPrincipal> t) {
            super(t);
        }

        public KafkaPrincipal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return SecurityUtils.parseKafkaPrincipal((String)jsonParser.getValueAsString());
        }
    }

    private static class ResourceTypeSerializer
    extends StdSerializer<ResourceType> {
        public ResourceTypeSerializer(Class<ResourceType> t) {
            super(t);
        }

        public void serialize(ResourceType resourceType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(resourceType.name());
        }
    }

    private static class ResourceTypeDeserializer
    extends StdDeserializer<ResourceType> {
        public ResourceTypeDeserializer(Class<ResourceType> t) {
            super(t);
        }

        public ResourceType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return ResourceType.resourceType((String)jsonParser.getValueAsString());
        }
    }

    private static class OperationSerializer
    extends StdSerializer<Operation> {
        public OperationSerializer(Class<Operation> t) {
            super(t);
        }

        public void serialize(Operation operation, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(operation.name());
        }
    }

    private static class OperationDeserializer
    extends StdDeserializer<Operation> {
        public OperationDeserializer(Class<Operation> t) {
            super(t);
        }

        public Operation deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new Operation(jsonParser.getValueAsString());
        }
    }

    private static class UuidSerializer
    extends StdSerializer<Uuid> {
        public UuidSerializer(Class<Uuid> t) {
            super(t);
        }

        public void serialize(Uuid uuid, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(uuid.toString());
        }
    }

    private static class UuidDeserializer
    extends StdDeserializer<Uuid> {
        public UuidDeserializer(Class<Uuid> t) {
            super(t);
        }

        public Uuid deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return Uuid.fromString((String)jsonParser.getValueAsString());
        }
    }

    public static class JwkJsonSerializer
    extends StdSerializer<JsonWebKey> {
        public JwkJsonSerializer(Class<JsonWebKey> t) {
            super(t);
        }

        public void serialize(JsonWebKey jsonWebKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)jsonWebKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC));
        }
    }

    public static class JwkJsonDeserializer
    extends StdDeserializer<JsonWebKey> {
        public JwkJsonDeserializer(Class<JsonWebKey> t) {
            super(t);
        }

        public JsonWebKey deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                Map params = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
                return JsonWebKey.Factory.newJwk((Map)params);
            }
            catch (JoseException e) {
                throw new JsonParseException(jsonParser, "Unable to parse Json Web Key", (Throwable)e);
            }
        }
    }

    public static class JwksJsonDeserializer
    extends StdDeserializer<JsonWebKeySet> {
        public JwksJsonDeserializer(Class<JsonWebKeySet> t) {
            super(t);
        }

        public JsonWebKeySet deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            jsonParser.nextValue();
            List jwks = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<JsonWebKey>>(){});
            return new JsonWebKeySet(jwks);
        }
    }
}

