/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;

public class VerticaDatabaseDialect
extends GenericDatabaseDialect {
    public VerticaDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL(18," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "INT";
            }
            case INT16: {
                return "INT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "INT";
            }
            case FLOAT32: {
                return "FLOAT";
            }
            case FLOAT64: {
                return "FLOAT";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR(1024)";
            }
            case BYTES: {
                return "VARBINARY(1024)";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ArrayList<String> queries = new ArrayList<String>(fields.size());
        for (SinkRecordField field : fields) {
            queries.addAll(super.buildAlterTable(table, Collections.singleton(field)));
        }
        return queries;
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(VerticaDatabaseDialect.class.getSimpleName(), "vertica");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new VerticaDatabaseDialect(config);
        }
    }
}

