/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;

public class PrimaryKeyModeRecommender
implements ConfigDef.Recommender {
    public static final PrimaryKeyModeRecommender INSTANCE = new PrimaryKeyModeRecommender();
    private static final List<Object> ALL_VALUES = Arrays.stream(JdbcSinkConfig.PrimaryKeyMode.values()).map(mode -> mode.name().toLowerCase()).collect(Collectors.toList());
    private static final List<Object> RECORD_KEY_ONLY = Collections.singletonList(JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY.name().toLowerCase());

    public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
        boolean deleteEnabled = (Boolean)parsedConfig.getOrDefault("delete.enabled", false);
        return deleteEnabled ? RECORD_KEY_ONLY : ALL_VALUES;
    }

    public boolean visible(String name, Map<String, Object> parsedConfig) {
        return true;
    }
}

