/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.TableId;
import io.confluent.connect.jdbc.util.TableType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TableDefinition {
    private final TableId id;
    private final Map<String, ColumnDefinition> columnsByName = new LinkedHashMap<String, ColumnDefinition>();
    private final Map<String, String> pkColumnNames = new LinkedHashMap<String, String>();
    private final TableType type;

    public TableDefinition(TableId id, Iterable<ColumnDefinition> columns) {
        this(id, columns, TableType.TABLE);
    }

    public TableDefinition(TableId id, Iterable<ColumnDefinition> columns, TableType type) {
        this.id = id;
        this.type = Objects.requireNonNull(type);
        for (ColumnDefinition defn : columns) {
            String columnName = defn.id().name();
            this.columnsByName.put(columnName, defn.forTable(this.id));
            if (!defn.isPrimaryKey()) continue;
            this.pkColumnNames.put(columnName, columnName);
        }
    }

    public TableId id() {
        return this.id;
    }

    public TableType type() {
        return this.type;
    }

    public int columnCount() {
        return this.columnsByName.size();
    }

    public ColumnDefinition definitionForColumn(String name) {
        return this.columnsByName.get(name);
    }

    public Collection<ColumnDefinition> definitionsForColumns() {
        return this.columnsByName.values();
    }

    public Collection<String> primaryKeyColumnNames() {
        return this.pkColumnNames.values();
    }

    public Set<String> columnNames() {
        return this.columnsByName.keySet();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof TableDefinition) {
            TableDefinition that = (TableDefinition)obj;
            return Objects.equals(this.id(), that.id()) && Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals(this.definitionsForColumns(), that.definitionsForColumns());
        }
        return false;
    }

    public String toString() {
        return String.format("Table{name='%s', type=%s columns=%s}", new Object[]{this.id, this.type, this.definitionsForColumns()});
    }
}

