/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc;

import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.JdbcSourceTask;
import io.confluent.connect.jdbc.source.TableMonitorThread;
import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import io.confluent.connect.jdbc.util.StringUtils;
import io.confluent.connect.jdbc.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceConnector.class);
    private static final long MAX_TIMEOUT = 10000L;
    private Map<String, String> configProperties;
    private JdbcSourceConnectorConfig config;
    private CachedConnectionProvider cachedConnectionProvider;
    private TableMonitorThread tableMonitorThread;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> properties) throws ConnectException {
        try {
            this.configProperties = properties;
            this.config = new JdbcSourceConnectorConfig(this.configProperties);
        }
        catch (ConfigException e) {
            throw new ConnectException("Couldn't start JdbcSourceConnector due to configuration error", (Throwable)e);
        }
        String dbUrl = this.config.getString("connection.url");
        String dbUser = this.config.getString("connection.user");
        Password dbPassword = this.config.getPassword("connection.password");
        this.cachedConnectionProvider = new CachedConnectionProvider(dbUrl, dbUser, dbPassword == null ? null : dbPassword.value());
        this.cachedConnectionProvider.getValidConnection();
        long tablePollMs = this.config.getLong("table.poll.interval.ms");
        List whitelist = this.config.getList("table.whitelist");
        HashSet<String> whitelistSet = whitelist.isEmpty() ? null : new HashSet(whitelist);
        List blacklist = this.config.getList("table.blacklist");
        HashSet<String> blacklistSet = blacklist.isEmpty() ? null : new HashSet<String>(blacklist);
        List tableTypes = this.config.getList("table.types");
        HashSet<String> tableTypesSet = new HashSet<String>(tableTypes);
        if (whitelistSet != null && blacklistSet != null) {
            throw new ConnectException("table.whitelist and table.blacklist are exclusive.");
        }
        String query = this.config.getString("query");
        String schemaPattern = this.config.getString("schema.pattern");
        if (!query.isEmpty()) {
            if (whitelistSet != null || blacklistSet != null) {
                throw new ConnectException("query may not be combined with whole-table copying settings.");
            }
            whitelistSet = Collections.emptySet();
        }
        this.tableMonitorThread = new TableMonitorThread(this.cachedConnectionProvider, this.context, schemaPattern, tablePollMs, whitelistSet, blacklistSet, tableTypesSet);
        this.tableMonitorThread.start();
    }

    public Class<? extends Task> taskClass() {
        return JdbcSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        String query = this.config.getString("query");
        if (!query.isEmpty()) {
            ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>(1);
            HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
            taskProps.put("tables", "");
            taskConfigs.add(taskProps);
            return taskConfigs;
        }
        List<String> currentTables = this.tableMonitorThread.tables();
        int numGroups = Math.min(currentTables.size(), maxTasks);
        List tablesGrouped = ConnectorUtils.groupPartitions(currentTables, (int)numGroups);
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>(tablesGrouped.size());
        for (List taskTables : tablesGrouped) {
            HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
            taskProps.put("tables", StringUtils.join(taskTables, ","));
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() throws ConnectException {
        log.info("Stopping table monitoring thread");
        this.tableMonitorThread.shutdown();
        try {
            this.tableMonitorThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cachedConnectionProvider.closeQuietly();
    }

    public ConfigDef config() {
        return JdbcSourceConnectorConfig.CONFIG_DEF;
    }
}

