/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class OracleDialect
extends DbDialect {
    public OracleDialect() {
        super("\"", "\"");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "NUMBER(*," + parameters.get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "NUMBER(3,0)";
            }
            case INT16: {
                return "NUMBER(5,0)";
            }
            case INT32: {
                return "NUMBER(10,0)";
            }
            case INT64: {
                return "NUMBER(19,0)";
            }
            case FLOAT32: {
                return "BINARY_FLOAT";
            }
            case FLOAT64: {
                return "BINARY_DOUBLE";
            }
            case BOOLEAN: {
                return "NUMBER(1,0)";
            }
            case STRING: {
                return "CLOB";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public List<String> getAlterTable(String tableName, Collection<SinkRecordField> fields) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        builder.append(this.escaped(tableName));
        builder.append(" ADD(");
        this.writeColumnsSpec(builder, fields);
        builder.append(")");
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder();
        builder.append("merge into ");
        final String tableName = this.escaped(table);
        builder.append(tableName);
        builder.append(" using (select ");
        StringBuilderUtil.joinToBuilder(builder, ", ", keyCols, cols, this.prefixedEscaper("? "));
        builder.append(" FROM dual) incoming on(");
        StringBuilderUtil.joinToBuilder(builder, " and ", keyCols, new StringBuilderUtil.Transform<String>(){

            @Override
            public void apply(StringBuilder builder, String col) {
                builder.append(tableName).append(".").append(OracleDialect.this.escaped(col)).append("=incoming.").append(OracleDialect.this.escaped(col));
            }
        });
        builder.append(")");
        if (cols != null && cols.size() > 0) {
            builder.append(" when matched then update set ");
            StringBuilderUtil.joinToBuilder(builder, ",", cols, new StringBuilderUtil.Transform<String>(){

                @Override
                public void apply(StringBuilder builder, String col) {
                    builder.append(tableName).append(".").append(OracleDialect.this.escaped(col)).append("=incoming.").append(OracleDialect.this.escaped(col));
                }
            });
        }
        builder.append(" when not matched then insert(");
        StringBuilderUtil.joinToBuilder(builder, ",", cols, keyCols, this.prefixedEscaper(tableName + "."));
        builder.append(") values(");
        StringBuilderUtil.joinToBuilder(builder, ",", cols, keyCols, this.prefixedEscaper("incoming."));
        builder.append(")");
        return builder.toString();
    }
}

