/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.DataConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;

abstract class TableQuerier
implements Comparable<TableQuerier> {
    protected final QueryMode mode;
    protected final String schemaPattern;
    protected final String name;
    protected final String query;
    protected final String topicPrefix;
    protected final boolean mapNumerics;
    protected long lastUpdate;
    protected PreparedStatement stmt;
    protected ResultSet resultSet;
    protected Schema schema;

    public TableQuerier(QueryMode mode, String nameOrQuery, String topicPrefix, String schemaPattern, boolean mapNumerics) {
        this.mode = mode;
        this.schemaPattern = schemaPattern;
        this.name = mode.equals((Object)QueryMode.TABLE) ? nameOrQuery : null;
        this.query = mode.equals((Object)QueryMode.QUERY) ? nameOrQuery : null;
        this.topicPrefix = topicPrefix;
        this.mapNumerics = mapNumerics;
        this.lastUpdate = 0L;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public PreparedStatement getOrCreatePreparedStatement(Connection db) throws SQLException {
        if (this.stmt != null) {
            return this.stmt;
        }
        this.createPreparedStatement(db);
        return this.stmt;
    }

    protected abstract void createPreparedStatement(Connection var1) throws SQLException;

    public boolean querying() {
        return this.resultSet != null;
    }

    public void maybeStartQuery(Connection db) throws SQLException {
        if (this.resultSet == null) {
            this.stmt = this.getOrCreatePreparedStatement(db);
            this.resultSet = this.executeQuery();
            this.schema = DataConverter.convertSchema(this.name, this.resultSet.getMetaData(), this.mapNumerics);
        }
    }

    protected abstract ResultSet executeQuery() throws SQLException;

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public abstract SourceRecord extractRecord() throws SQLException;

    public void reset(long now) {
        this.closeResultSetQuietly();
        this.closeStatementQuietly();
        this.schema = null;
        this.lastUpdate = now;
    }

    private void closeStatementQuietly() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.stmt = null;
    }

    private void closeResultSetQuietly() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.resultSet = null;
    }

    @Override
    public int compareTo(TableQuerier other) {
        if (this.lastUpdate < other.lastUpdate) {
            return -1;
        }
        if (this.lastUpdate > other.lastUpdate) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }

    public static enum QueryMode {
        TABLE,
        QUERY;

    }
}

