/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class TimestampIncrementingOffset {
    private static final String INCREMENTING_FIELD = "incrementing";
    private static final String TIMESTAMP_FIELD = "timestamp";
    private static final String TIMESTAMP_NANOS_FIELD = "timestamp_nanos";
    private final Long incrementingOffset;
    private final Timestamp timestampOffset;

    public TimestampIncrementingOffset(Timestamp timestampOffset, Long incrementingOffset) {
        this.timestampOffset = timestampOffset;
        this.incrementingOffset = incrementingOffset;
    }

    public long getIncrementingOffset() {
        return this.incrementingOffset == null ? -1L : this.incrementingOffset;
    }

    public Timestamp getTimestampOffset() {
        return this.timestampOffset == null ? new Timestamp(0L) : this.timestampOffset;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (this.incrementingOffset != null) {
            map.put(INCREMENTING_FIELD, this.incrementingOffset);
        }
        if (this.timestampOffset != null) {
            map.put(TIMESTAMP_FIELD, this.timestampOffset.getTime());
            map.put(TIMESTAMP_NANOS_FIELD, this.timestampOffset.getNanos());
        }
        return map;
    }

    public static TimestampIncrementingOffset fromMap(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return new TimestampIncrementingOffset(null, null);
        }
        Long incr = (Long)map.get(INCREMENTING_FIELD);
        Long millis = (Long)map.get(TIMESTAMP_FIELD);
        Timestamp ts = null;
        if (millis != null) {
            ts = new Timestamp(millis);
            Long nanos = (Long)map.get(TIMESTAMP_NANOS_FIELD);
            if (nanos != null) {
                ts.setNanos(nanos.intValue());
            }
        }
        return new TimestampIncrementingOffset(ts, incr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampIncrementingOffset that = (TimestampIncrementingOffset)o;
        if (this.incrementingOffset != null ? !this.incrementingOffset.equals(that.incrementingOffset) : that.incrementingOffset != null) {
            return false;
        }
        return this.timestampOffset != null ? this.timestampOffset.equals(that.timestampOffset) : that.timestampOffset == null;
    }

    public int hashCode() {
        int result = this.incrementingOffset != null ? this.incrementingOffset.hashCode() : 0;
        result = 31 * result + (this.timestampOffset != null ? this.timestampOffset.hashCode() : 0);
        return result;
    }
}

