/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(CachedConnectionProvider.class);
    private static final int VALIDITY_CHECK_TIMEOUT_S = 5;
    private final String url;
    private final String username;
    private final String password;
    private Connection connection;

    public CachedConnectionProvider(String url) {
        this(url, null, null);
    }

    public CachedConnectionProvider(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public synchronized Connection getValidConnection() {
        try {
            if (this.connection == null) {
                this.newConnection();
            } else if (!this.connection.isValid(5)) {
                log.info("The database connection is invalid. Reconnecting...");
                this.closeQuietly();
                this.newConnection();
            }
        }
        catch (SQLException sqle) {
            throw new ConnectException((Throwable)sqle);
        }
        return this.connection;
    }

    private void newConnection() throws SQLException {
        log.debug("Attempting to connect to {}", (Object)this.url);
        this.connection = DriverManager.getConnection(this.url, this.username, this.password);
        this.onConnect(this.connection);
    }

    public synchronized void closeQuietly() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException sqle) {
                log.warn("Ignoring error closing connection", (Throwable)sqle);
            }
        }
    }

    protected void onConnect(Connection connection) throws SQLException {
    }
}

