/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.SchemaMapping;
import io.confluent.connect.jdbc.source.TableQuerier;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkTableQuerier
extends TableQuerier {
    private static final Logger log = LoggerFactory.getLogger(BulkTableQuerier.class);

    public BulkTableQuerier(DatabaseDialect dialect, TableQuerier.QueryMode mode, String name, String topicPrefix) {
        super(dialect, mode, name, topicPrefix);
    }

    @Override
    protected void createPreparedStatement(Connection db) throws SQLException {
        switch (this.mode) {
            case TABLE: {
                String queryStr = this.dialect.expressionBuilder().append("SELECT * FROM ").append(this.tableId).toString();
                this.recordQuery(queryStr);
                log.debug("{} prepared SQL query: {}", (Object)this, (Object)queryStr);
                this.stmt = this.dialect.createPreparedStatement(db, queryStr);
                break;
            }
            case QUERY: {
                this.recordQuery(this.query);
                log.debug("{} prepared SQL query: {}", (Object)this, (Object)this.query);
                this.stmt = this.dialect.createPreparedStatement(db, this.query);
                break;
            }
            default: {
                throw new ConnectException("Unknown mode: " + (Object)((Object)this.mode));
            }
        }
    }

    @Override
    protected ResultSet executeQuery() throws SQLException {
        return this.stmt.executeQuery();
    }

    @Override
    public SourceRecord extractRecord() throws SQLException {
        String topic;
        Map<String, String> partition;
        Struct record = new Struct(this.schemaMapping.schema());
        for (SchemaMapping.FieldSetter setter : this.schemaMapping.fieldSetters()) {
            try {
                setter.setField(record, this.resultSet);
            }
            catch (IOException e) {
                log.warn("Error mapping fields into Connect record", (Throwable)e);
                throw new ConnectException((Throwable)e);
            }
            catch (SQLException e) {
                log.warn("SQL error mapping fields into Connect record", (Throwable)e);
                throw new DataException((Throwable)e);
            }
        }
        switch (this.mode) {
            case TABLE: {
                String name = this.tableId.tableName();
                partition = Collections.singletonMap("table", name);
                topic = this.topicPrefix + name;
                break;
            }
            case QUERY: {
                partition = Collections.singletonMap("query", "query");
                topic = this.topicPrefix;
                break;
            }
            default: {
                throw new ConnectException("Unexpected query mode: " + (Object)((Object)this.mode));
            }
        }
        return new SourceRecord(partition, null, topic, record.schema(), (Object)record);
    }

    public String toString() {
        return "BulkTableQuerier{table='" + this.tableId + '\'' + ", query='" + this.query + '\'' + ", topicPrefix='" + this.topicPrefix + '\'' + '}';
    }
}

