/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import org.apache.kafka.common.config.AbstractConfig;

public class Db2DatabaseDialect
extends GenericDatabaseDialect {
    public Db2DatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected String currentTimestampDatabaseQuery() {
        return "SELECT CURRENT_TIMESTAMP(12) FROM SYSIBM.SYSDUMMY1;";
    }

    @Override
    protected String checkConnectionQuery() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL(31," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "SMALLINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INTEGER";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "FLOAT";
            }
            case FLOAT64: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "SMALLINT";
            }
            case STRING: {
                return "VARCHAR(32672)";
            }
            case BYTES: {
                return "BLOB(64000)";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> builder.append(table).append(".").appendColumnName(col.name()).append("=DAT.").appendColumnName(col.name());
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("merge into ");
        builder2.append(table);
        builder2.append(" using (values(");
        builder2.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.placeholderInsteadOfColumnNames("?")).of(keyColumns, nonKeyColumns);
        builder2.append(")) as DAT(");
        builder2.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder2.append(") on ");
        builder2.appendList().delimitedBy(" and ").transformedBy(transform).of(keyColumns);
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder2.append(" when matched then update set ");
            builder2.appendList().delimitedBy(", ").transformedBy(transform).of(nonKeyColumns);
        }
        builder2.append(" when not matched then insert(");
        builder2.appendList().delimitedBy(",").of(nonKeyColumns, keyColumns);
        builder2.append(") values(");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("DAT.")).of(nonKeyColumns, keyColumns);
        builder2.append(")");
        return builder2.toString();
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(?i)([:;]password=)[^;]*", "$1****");
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(Db2DatabaseDialect.class.getSimpleName(), "db2", "db2j", "ibmdb");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new Db2DatabaseDialect(config);
        }
    }
}

