/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.util.DatabaseDialectRecommender;
import io.confluent.connect.jdbc.util.EnumRecommender;
import io.confluent.connect.jdbc.util.QuoteMethod;
import io.confluent.connect.jdbc.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class JdbcSinkConfig
extends AbstractConfig {
    public static final List<String> DEFAULT_KAFKA_PK_NAMES = Collections.unmodifiableList(Arrays.asList("__connect_topic", "__connect_partition", "__connect_offset"));
    public static final String CONNECTION_URL = "connection.url";
    private static final String CONNECTION_URL_DOC = "JDBC connection URL.";
    private static final String CONNECTION_URL_DISPLAY = "JDBC URL";
    public static final String CONNECTION_USER = "connection.user";
    private static final String CONNECTION_USER_DOC = "JDBC connection user.";
    private static final String CONNECTION_USER_DISPLAY = "JDBC User";
    public static final String CONNECTION_PASSWORD = "connection.password";
    private static final String CONNECTION_PASSWORD_DOC = "JDBC connection password.";
    private static final String CONNECTION_PASSWORD_DISPLAY = "JDBC Password";
    public static final String TABLE_NAME_FORMAT = "table.name.format";
    private static final String TABLE_NAME_FORMAT_DEFAULT = "${topic}";
    private static final String TABLE_NAME_FORMAT_DOC = "A format string for the destination table name, which may contain '${topic}' as a placeholder for the originating topic name.\nFor example, ``kafka_${topic}`` for the topic 'orders' will map to the table name 'kafka_orders'.";
    private static final String TABLE_NAME_FORMAT_DISPLAY = "Table Name Format";
    public static final String MAX_RETRIES = "max.retries";
    private static final int MAX_RETRIES_DEFAULT = 10;
    private static final String MAX_RETRIES_DOC = "The maximum number of times to retry on errors before failing the task.";
    private static final String MAX_RETRIES_DISPLAY = "Maximum Retries";
    public static final String RETRY_BACKOFF_MS = "retry.backoff.ms";
    private static final int RETRY_BACKOFF_MS_DEFAULT = 3000;
    private static final String RETRY_BACKOFF_MS_DOC = "The time in milliseconds to wait following an error before a retry attempt is made.";
    private static final String RETRY_BACKOFF_MS_DISPLAY = "Retry Backoff (millis)";
    public static final String BATCH_SIZE = "batch.size";
    private static final int BATCH_SIZE_DEFAULT = 3000;
    private static final String BATCH_SIZE_DOC = "Specifies how many records to attempt to batch together for insertion into the destination table, when possible.";
    private static final String BATCH_SIZE_DISPLAY = "Batch Size";
    public static final String AUTO_CREATE = "auto.create";
    private static final String AUTO_CREATE_DEFAULT = "false";
    private static final String AUTO_CREATE_DOC = "Whether to automatically create the destination table based on record schema if it is found to be missing by issuing ``CREATE``.";
    private static final String AUTO_CREATE_DISPLAY = "Auto-Create";
    public static final String AUTO_EVOLVE = "auto.evolve";
    private static final String AUTO_EVOLVE_DEFAULT = "false";
    private static final String AUTO_EVOLVE_DOC = "Whether to automatically add columns in the table schema when found to be missing relative to the record schema by issuing ``ALTER``.";
    private static final String AUTO_EVOLVE_DISPLAY = "Auto-Evolve";
    public static final String INSERT_MODE = "insert.mode";
    private static final String INSERT_MODE_DEFAULT = "insert";
    private static final String INSERT_MODE_DOC = "The insertion mode to use. Supported modes are:\n``insert``\n    Use standard SQL ``INSERT`` statements.\n``upsert``\n    Use the appropriate upsert semantics for the target database if it is supported by the connector, e.g. ``INSERT OR IGNORE``.\n``update``\n    Use the appropriate update semantics for the target database if it is supported by the connector, e.g. ``UPDATE``.";
    private static final String INSERT_MODE_DISPLAY = "Insert Mode";
    public static final String PK_FIELDS = "pk.fields";
    private static final String PK_FIELDS_DEFAULT = "";
    private static final String PK_FIELDS_DOC = "List of comma-separated primary key field names. The runtime interpretation of this config depends on the ``pk.mode``:\n``none``\n    Ignored as no fields are used as primary key in this mode.\n``kafka``\n    Must be a trio representing the Kafka coordinates, defaults to ``" + StringUtils.join(DEFAULT_KAFKA_PK_NAMES, ",") + "`` if empty.\n``record_key``\n    If empty, all fields from the key struct will be used, otherwise used to extract the desired fields - for primitive key only a single field name must be configured.\n``record_value``\n    If empty, all fields from the value struct will be used, otherwise used to extract the desired fields.";
    private static final String PK_FIELDS_DISPLAY = "Primary Key Fields";
    public static final String PK_MODE = "pk.mode";
    private static final String PK_MODE_DEFAULT = "none";
    private static final String PK_MODE_DOC = "The primary key mode, also refer to ``pk.fields`` documentation for interplay. Supported modes are:\n``none``\n    No keys utilized.\n``kafka``\n    Kafka coordinates are used as the PK.\n``record_key``\n    Field(s) from the record key are used, which may be a primitive or a struct.\n``record_value``\n    Field(s) from the record value are used, which must be a struct.";
    private static final String PK_MODE_DISPLAY = "Primary Key Mode";
    public static final String FIELDS_WHITELIST = "fields.whitelist";
    private static final String FIELDS_WHITELIST_DEFAULT = "";
    private static final String FIELDS_WHITELIST_DOC = "List of comma-separated record value field names. If empty, all fields from the record value are utilized, otherwise used to filter to the desired fields.\nNote that ``pk.fields`` is applied independently in the context of which field(s) form the primary key columns in the destination database, while this configuration is applicable for the other columns.";
    private static final String FIELDS_WHITELIST_DISPLAY = "Fields Whitelist";
    private static final ConfigDef.Range NON_NEGATIVE_INT_VALIDATOR = ConfigDef.Range.atLeast((Number)0);
    private static final String CONNECTION_GROUP = "Connection";
    private static final String WRITES_GROUP = "Writes";
    private static final String DATAMAPPING_GROUP = "Data Mapping";
    private static final String DDL_GROUP = "SQL/DDL Support";
    private static final String RETRIES_GROUP = "Retries";
    public static final String DIALECT_NAME_CONFIG = "dialect.name";
    private static final String DIALECT_NAME_DISPLAY = "Database Dialect";
    public static final String DIALECT_NAME_DEFAULT = "";
    private static final String DIALECT_NAME_DOC = "The name of the database dialect that should be used for this connector. By default this is empty, and the connector automatically determines the dialect based upon the JDBC connection URL. Use this if you want to override that behavior and use a specific dialect. All properly-packaged dialects in the JDBC connector plugin can be used.";
    public static final String QUOTE_SQL_IDENTIFIERS_CONFIG = "quote.sql.identifiers";
    public static final String QUOTE_SQL_IDENTIFIERS_DEFAULT = JdbcSourceConnectorConfig.QUOTE_SQL_IDENTIFIERS_DEFAULT;
    public static final String QUOTE_SQL_IDENTIFIERS_DOC = "When to quote table names, column names, and other identifiers in SQL statements. For backward compatibility, the default is 'always'.";
    private static final String QUOTE_SQL_IDENTIFIERS_DISPLAY = "Quote Identifiers";
    private static final EnumRecommender QUOTE_METHOD_RECOMMENDER = EnumRecommender.in(QuoteMethod.values());
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("connection.url", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "JDBC connection URL.", "Connection", 1, ConfigDef.Width.LONG, "JDBC URL").define("connection.user", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "JDBC connection user.", "Connection", 2, ConfigDef.Width.MEDIUM, "JDBC User").define("connection.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "JDBC connection password.", "Connection", 3, ConfigDef.Width.MEDIUM, "JDBC Password").define("dialect.name", ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)DatabaseDialectRecommender.INSTANCE, ConfigDef.Importance.LOW, "The name of the database dialect that should be used for this connector. By default this is empty, and the connector automatically determines the dialect based upon the JDBC connection URL. Use this if you want to override that behavior and use a specific dialect. All properly-packaged dialects in the JDBC connector plugin can be used.", "Connection", 4, ConfigDef.Width.LONG, "Database Dialect", (ConfigDef.Recommender)DatabaseDialectRecommender.INSTANCE).define("insert.mode", ConfigDef.Type.STRING, (Object)"insert", (ConfigDef.Validator)EnumValidator.in(InsertMode.values()), ConfigDef.Importance.HIGH, "The insertion mode to use. Supported modes are:\n``insert``\n    Use standard SQL ``INSERT`` statements.\n``upsert``\n    Use the appropriate upsert semantics for the target database if it is supported by the connector, e.g. ``INSERT OR IGNORE``.\n``update``\n    Use the appropriate update semantics for the target database if it is supported by the connector, e.g. ``UPDATE``.", "Writes", 1, ConfigDef.Width.MEDIUM, "Insert Mode").define("batch.size", ConfigDef.Type.INT, (Object)3000, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "Specifies how many records to attempt to batch together for insertion into the destination table, when possible.", "Writes", 2, ConfigDef.Width.SHORT, "Batch Size").define("table.name.format", ConfigDef.Type.STRING, (Object)"${topic}", ConfigDef.Importance.MEDIUM, "A format string for the destination table name, which may contain '${topic}' as a placeholder for the originating topic name.\nFor example, ``kafka_${topic}`` for the topic 'orders' will map to the table name 'kafka_orders'.", "Data Mapping", 1, ConfigDef.Width.LONG, "Table Name Format").define("pk.mode", ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)EnumValidator.in(PrimaryKeyMode.values()), ConfigDef.Importance.HIGH, "The primary key mode, also refer to ``pk.fields`` documentation for interplay. Supported modes are:\n``none``\n    No keys utilized.\n``kafka``\n    Kafka coordinates are used as the PK.\n``record_key``\n    Field(s) from the record key are used, which may be a primitive or a struct.\n``record_value``\n    Field(s) from the record value are used, which must be a struct.", "Data Mapping", 2, ConfigDef.Width.MEDIUM, "Primary Key Mode").define("pk.fields", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, PK_FIELDS_DOC, "Data Mapping", 3, ConfigDef.Width.LONG, "Primary Key Fields").define("fields.whitelist", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "List of comma-separated record value field names. If empty, all fields from the record value are utilized, otherwise used to filter to the desired fields.\nNote that ``pk.fields`` is applied independently in the context of which field(s) form the primary key columns in the destination database, while this configuration is applicable for the other columns.", "Data Mapping", 4, ConfigDef.Width.LONG, "Fields Whitelist").define("auto.create", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Whether to automatically create the destination table based on record schema if it is found to be missing by issuing ``CREATE``.", "SQL/DDL Support", 1, ConfigDef.Width.SHORT, "Auto-Create").define("auto.evolve", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Whether to automatically add columns in the table schema when found to be missing relative to the record schema by issuing ``ALTER``.", "SQL/DDL Support", 2, ConfigDef.Width.SHORT, "Auto-Evolve").define("quote.sql.identifiers", ConfigDef.Type.STRING, (Object)QUOTE_SQL_IDENTIFIERS_DEFAULT, ConfigDef.Importance.MEDIUM, "When to quote table names, column names, and other identifiers in SQL statements. For backward compatibility, the default is 'always'.", "SQL/DDL Support", 3, ConfigDef.Width.MEDIUM, "Quote Identifiers", (ConfigDef.Recommender)QUOTE_METHOD_RECOMMENDER).define("max.retries", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "The maximum number of times to retry on errors before failing the task.", "Retries", 1, ConfigDef.Width.SHORT, "Maximum Retries").define("retry.backoff.ms", ConfigDef.Type.INT, (Object)3000, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "The time in milliseconds to wait following an error before a retry attempt is made.", "Retries", 2, ConfigDef.Width.SHORT, "Retry Backoff (millis)");
    public final String connectionUrl = this.getString("connection.url");
    public final String connectionUser = this.getString("connection.user");
    public final String connectionPassword = this.getPasswordValue("connection.password");
    public final String tableNameFormat = this.getString("table.name.format").trim();
    public final int batchSize = this.getInt("batch.size");
    public final int maxRetries = this.getInt("max.retries");
    public final int retryBackoffMs = this.getInt("retry.backoff.ms");
    public final boolean autoCreate = this.getBoolean("auto.create");
    public final boolean autoEvolve = this.getBoolean("auto.evolve");
    public final InsertMode insertMode = InsertMode.valueOf(this.getString("insert.mode").toUpperCase());
    public final PrimaryKeyMode pkMode = PrimaryKeyMode.valueOf(this.getString("pk.mode").toUpperCase());
    public final List<String> pkFields = this.getList("pk.fields");
    public final Set<String> fieldsWhitelist;
    public final String dialectName = this.getString("dialect.name");

    public JdbcSinkConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props);
        this.fieldsWhitelist = new HashSet<String>(this.getList(FIELDS_WHITELIST));
    }

    private String getPasswordValue(String key) {
        Password password = this.getPassword(key);
        if (password != null) {
            return password.value();
        }
        return null;
    }

    public static void main(String ... args) {
        System.out.println(CONFIG_DEF.toEnrichedRst());
    }

    private static class EnumValidator
    implements ConfigDef.Validator {
        private final List<String> canonicalValues;
        private final Set<String> validValues;

        private EnumValidator(List<String> canonicalValues, Set<String> validValues) {
            this.canonicalValues = canonicalValues;
            this.validValues = validValues;
        }

        public static <E> EnumValidator in(E[] enumerators) {
            ArrayList<String> canonicalValues = new ArrayList<String>(enumerators.length);
            HashSet<String> validValues = new HashSet<String>(enumerators.length * 2);
            for (E e : enumerators) {
                canonicalValues.add(e.toString().toLowerCase());
                validValues.add(e.toString().toUpperCase());
                validValues.add(e.toString().toLowerCase());
            }
            return new EnumValidator(canonicalValues, validValues);
        }

        public void ensureValid(String key, Object value) {
            if (!this.validValues.contains(value)) {
                throw new ConfigException(key, value, "Invalid enumerator");
            }
        }

        public String toString() {
            return this.canonicalValues.toString();
        }
    }

    public static enum PrimaryKeyMode {
        NONE,
        KAFKA,
        RECORD_KEY,
        RECORD_VALUE;

    }

    public static enum InsertMode {
        INSERT,
        UPSERT,
        UPDATE;

    }
}

