/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialects;
import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.JdbcDbWriter;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkTask
extends SinkTask {
    private static final Logger log = LoggerFactory.getLogger(JdbcSinkTask.class);
    DatabaseDialect dialect;
    JdbcSinkConfig config;
    JdbcDbWriter writer;
    int remainingRetries;

    public void start(Map<String, String> props) {
        log.info("Starting JDBC Sink task");
        this.config = new JdbcSinkConfig(props);
        this.initWriter();
        this.remainingRetries = this.config.maxRetries;
    }

    void initWriter() {
        this.dialect = this.config.dialectName != null && !this.config.dialectName.trim().isEmpty() ? DatabaseDialects.create(this.config.dialectName, this.config) : DatabaseDialects.findBestFor(this.config.connectionUrl, this.config);
        DbStructure dbStructure = new DbStructure(this.dialect);
        log.info("Initializing writer using SQL dialect: {}", (Object)this.dialect.getClass().getSimpleName());
        this.writer = new JdbcDbWriter(this.config, this.dialect, dbStructure);
    }

    public void put(Collection<SinkRecord> records) {
        if (records.isEmpty()) {
            return;
        }
        SinkRecord first = records.iterator().next();
        int recordsCount = records.size();
        log.debug("Received {} records. First record kafka coordinates:({}-{}-{}). Writing them to the database...", new Object[]{recordsCount, first.topic(), first.kafkaPartition(), first.kafkaOffset()});
        try {
            this.writer.write(records);
        }
        catch (SQLException sqle) {
            log.warn("Write of {} records failed, remainingRetries={}", new Object[]{records.size(), this.remainingRetries, sqle});
            String sqleAllMessages = "";
            for (Throwable e : sqle) {
                sqleAllMessages = sqleAllMessages + e + System.lineSeparator();
            }
            if (this.remainingRetries == 0) {
                throw new ConnectException((Throwable)new SQLException(sqleAllMessages));
            }
            this.writer.closeQuietly();
            this.initWriter();
            --this.remainingRetries;
            this.context.timeout((long)this.config.retryBackoffMs);
            throw new RetriableException((Throwable)new SQLException(sqleAllMessages));
        }
        this.remainingRetries = this.config.maxRetries;
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stopping task");
        try {
            this.writer.closeQuietly();
        }
        finally {
            try {
                if (this.dialect != null) {
                    this.dialect.close();
                }
            }
            catch (Throwable t) {
                log.warn("Error while closing the {} dialect: ", (Object)this.dialect.name(), (Object)t);
            }
            finally {
                this.dialect = null;
            }
        }
    }

    public String version() {
        return ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
    }
}

