/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.util.ColumnDefinition;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;

public class ColumnMapping {
    private final Field field;
    private final ColumnDefinition columnDefn;
    private final int columnNumber;
    private final int hash;

    public ColumnMapping(ColumnDefinition columnDefn, int columnNumber, Field field) {
        assert (columnDefn != null);
        assert (field != null);
        assert (columnNumber > 0);
        this.columnDefn = columnDefn;
        this.field = field;
        this.columnNumber = columnNumber;
        this.hash = Objects.hash(this.columnNumber, this.columnDefn, this.field);
    }

    public Field field() {
        return this.field;
    }

    public ColumnDefinition columnDefn() {
        return this.columnDefn;
    }

    public int columnNumber() {
        return this.columnNumber;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ColumnMapping) {
            ColumnMapping that = (ColumnMapping)obj;
            return this.columnNumber == that.columnNumber && Objects.equals(this.columnDefn, that.columnDefn) && Objects.equals(this.field, that.field);
        }
        return false;
    }

    public String toString() {
        return this.field.name() + " (col=" + this.columnNumber + ", " + this.columnDefn + ")";
    }
}

