/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.QuoteMethod;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Objects;

public class ColumnId
implements ExpressionBuilder.Expressable {
    private final TableId tableId;
    private final String name;
    private final String alias;
    private final int hash;

    public ColumnId(TableId tableId, String columnName) {
        this(tableId, columnName, null);
    }

    public ColumnId(TableId tableId, String columnName, String alias) {
        assert (columnName != null);
        this.tableId = tableId;
        this.name = columnName;
        this.alias = alias != null && !alias.trim().isEmpty() ? alias : this.name;
        this.hash = Objects.hash(this.tableId, this.name);
    }

    public TableId tableId() {
        return this.tableId;
    }

    public String name() {
        return this.name;
    }

    public String aliasOrName() {
        return this.alias;
    }

    @Override
    public void appendTo(ExpressionBuilder builder, boolean useQuotes) {
        this.appendTo(builder, useQuotes ? QuoteMethod.ALWAYS : QuoteMethod.NEVER);
    }

    @Override
    public void appendTo(ExpressionBuilder builder, QuoteMethod useQuotes) {
        if (this.tableId != null) {
            builder.append(this.tableId);
            builder.appendIdentifierDelimiter();
        }
        builder.appendColumnName(this.name, useQuotes);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ColumnId) {
            ColumnId that = (ColumnId)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.alias, that.alias) && Objects.equals(this.tableId, that.tableId);
        }
        return false;
    }

    public String toString() {
        return ExpressionBuilder.create().append(this).toString();
    }
}

