/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.kafka.common.config.AbstractConfig;

public class MySqlDatabaseDialect
extends GenericDatabaseDialect {
    public MySqlDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "`", "`"));
    }

    @Override
    protected void initializePreparedStatement(PreparedStatement stmt) throws SQLException {
        this.log.trace("Initializing PreparedStatement fetch direction to FETCH_FORWARD for '{}'", (Object)stmt);
        stmt.setFetchDirection(1000);
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    int scale = Integer.parseInt(field.schemaParameters().get("scale"));
                    return "DECIMAL(65," + scale + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME(3)";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "DATETIME(3)";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "TINYINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "FLOAT";
            }
            case FLOAT64: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "TINYINT";
            }
            case STRING: {
                return "VARCHAR(256)";
            }
            case BYTES: {
                return "VARBINARY(1024)";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> {
            builder.appendColumnName(col.name());
            builder.append("=values(");
            builder.appendColumnName(col.name());
            builder.append(")");
        };
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("insert into ");
        builder2.append(table);
        builder2.append("(");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder2.append(") values(");
        builder2.appendMultiple(",", "?", keyColumns.size() + nonKeyColumns.size());
        builder2.append(") on duplicate key update ");
        builder2.appendList().delimitedBy(",").transformedBy(transform).of(nonKeyColumns.isEmpty() ? keyColumns : nonKeyColumns);
        return builder2.toString();
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(?i)([(,]password=)[^,)]*", "$1****").replaceAll("(://[^:]*:)([^@]*)@", "$1****@");
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(MySqlDatabaseDialect.class.getSimpleName(), "mariadb", "mysql");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new MySqlDatabaseDialect(config);
        }
    }
}

