/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;

public class SqlServerDatabaseDialect
extends GenericDatabaseDialect {
    public SqlServerDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "[", "]"));
    }

    @Override
    protected boolean useCatalog() {
        return true;
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "decimal(38," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "date";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "time";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "datetime2";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "tinyint";
            }
            case INT16: {
                return "smallint";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "bigint";
            }
            case FLOAT32: {
                return "real";
            }
            case FLOAT64: {
                return "float";
            }
            case BOOLEAN: {
                return "bit";
            }
            case STRING: {
                return "varchar(max)";
            }
            case BYTES: {
                return "varbinary(max)";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        if (options.ifExists()) {
            builder.append("IF OBJECT_ID('");
            builder.append(table);
            builder.append(", 'U') IS NOT NULL");
        }
        builder.append("DROP TABLE ");
        builder.append(table);
        if (options.cascade()) {
            builder.append(" CASCADE");
        }
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD");
        this.writeColumnsSpec(builder, fields);
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("merge into ");
        builder.append(table);
        builder.append(" with (HOLDLOCK) AS target using (select ");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWithPrefix("? AS ")).of(keyColumns, nonKeyColumns);
        builder.append(") AS incoming on (");
        builder.appendList().delimitedBy(" and ").transformedBy(this::transformAs).of(keyColumns);
        builder.append(")");
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder.append(" when matched then update set ");
            builder.appendList().delimitedBy(",").transformedBy(this::transformUpdate).of(nonKeyColumns);
        }
        builder.append(" when not matched then insert (");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNames()).of(nonKeyColumns, keyColumns);
        builder.append(") values (");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("incoming.")).of(nonKeyColumns, keyColumns);
        builder.append(");");
        return builder.toString();
    }

    @Override
    protected ColumnDefinition columnDefinition(ResultSet resultSet, ColumnId id, int jdbcType, String typeName, String classNameForType, ColumnDefinition.Nullability nullability, ColumnDefinition.Mutability mutability, int precision, int scale, Boolean signedNumbers, Integer displaySize, Boolean autoIncremented, Boolean caseSensitive, Boolean searchable, Boolean currency, Boolean isPrimaryKey) {
        try {
            String isAutoIncremented = resultSet.getString(22);
            if ("yes".equalsIgnoreCase(isAutoIncremented)) {
                autoIncremented = Boolean.TRUE;
            } else if ("no".equalsIgnoreCase(isAutoIncremented)) {
                autoIncremented = Boolean.FALSE;
            }
        }
        catch (SQLException e) {
            this.log.warn("Unable to get auto incrementing column information", (Throwable)e);
        }
        return super.columnDefinition(resultSet, id, jdbcType, typeName, classNameForType, nullability, mutability, precision, scale, signedNumbers, displaySize, autoIncremented, caseSensitive, searchable, currency, isPrimaryKey);
    }

    private void transformAs(ExpressionBuilder builder, ColumnId col) {
        builder.append("target.").appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    private void transformUpdate(ExpressionBuilder builder, ColumnId col) {
        builder.appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(?i)(;password=)[^;]*", "$1****").replaceAll("(?i)(;keyStoreSecret=)[^;]*", "$1****").replaceAll("(?i)(;gsscredential=)[^;]*", "$1****");
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(SqlServerDatabaseDialect.class.getSimpleName(), "microsoft:sqlserver", "sqlserver", "jtds:sqlserver");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new SqlServerDatabaseDialect(config);
        }
    }
}

