/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.metadata;

import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class SinkRecordField {
    private final Schema schema;
    private final String name;
    private final boolean isPrimaryKey;

    public SinkRecordField(Schema schema, String name, boolean isPrimaryKey) {
        this.schema = schema;
        this.name = name;
        this.isPrimaryKey = isPrimaryKey;
    }

    public String schemaName() {
        return this.schema.name();
    }

    public Map<String, String> schemaParameters() {
        return this.schema.parameters();
    }

    public Schema.Type schemaType() {
        return this.schema.type();
    }

    public String name() {
        return this.name;
    }

    public boolean isOptional() {
        return !this.isPrimaryKey && this.schema.isOptional();
    }

    public Object defaultValue() {
        return this.schema.defaultValue();
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String toString() {
        return "SinkRecordField{schema=" + this.schema + ", name='" + this.name + '\'' + ", isPrimaryKey=" + this.isPrimaryKey + '}';
    }
}

