/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableDefinitions;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbStructure {
    private static final Logger log = LoggerFactory.getLogger(DbStructure.class);
    private final DatabaseDialect dbDialect;
    private final TableDefinitions tableDefns;

    public DbStructure(DatabaseDialect dbDialect) {
        this.dbDialect = dbDialect;
        this.tableDefns = new TableDefinitions(dbDialect);
    }

    public boolean createOrAmendIfNecessary(JdbcSinkConfig config, Connection connection, TableId tableId, FieldsMetadata fieldsMetadata) throws SQLException {
        if (this.tableDefns.get(connection, tableId) == null) {
            try {
                this.create(config, connection, tableId, fieldsMetadata);
            }
            catch (SQLException sqle) {
                log.warn("Create failed, will attempt amend if table already exists", (Throwable)sqle);
                try {
                    TableDefinition newDefn = this.tableDefns.refresh(connection, tableId);
                    if (newDefn == null) {
                        throw sqle;
                    }
                }
                catch (SQLException e) {
                    throw sqle;
                }
            }
        }
        return this.amendIfNecessary(config, connection, tableId, fieldsMetadata, config.maxRetries);
    }

    void create(JdbcSinkConfig config, Connection connection, TableId tableId, FieldsMetadata fieldsMetadata) throws SQLException {
        if (!config.autoCreate) {
            throw new ConnectException(String.format("Table %s is missing and auto-creation is disabled", tableId));
        }
        String sql = this.dbDialect.buildCreateTableStatement(tableId, fieldsMetadata.allFields.values());
        log.info("Creating table with sql: {}", (Object)sql);
        this.dbDialect.applyDdlStatements(connection, Collections.singletonList(sql));
    }

    boolean amendIfNecessary(JdbcSinkConfig config, Connection connection, TableId tableId, FieldsMetadata fieldsMetadata, int maxRetries) throws SQLException {
        TableDefinition tableDefn = this.tableDefns.get(connection, tableId);
        if (tableDefn == null) {
            throw new SQLException("Table with id " + tableId + "does not exist in database. Since we've either already auto-created the table or confirmed it existed before this point, it must mean this user does not have the permission to read the column data for this table.");
        }
        Set<SinkRecordField> missingFields = this.missingFields(fieldsMetadata.allFields.values(), tableDefn.columnNames());
        if (missingFields.isEmpty()) {
            return false;
        }
        for (SinkRecordField missingField : missingFields) {
            if (missingField.isOptional() || missingField.defaultValue() != null) continue;
            throw new ConnectException(String.format("Cannot ALTER %s to add missing field %s, as it is not optional and does not have a default value", tableId, missingField));
        }
        if (!config.autoEvolve) {
            throw new ConnectException(String.format("Table %s is missing fields (%s) and auto-evolution is disabled", tableId, missingFields));
        }
        List<String> amendTableQueries = this.dbDialect.buildAlterTable(tableId, missingFields);
        log.info("Amending table to add missing fields:{} maxRetries:{} with SQL: {}", new Object[]{missingFields, maxRetries, amendTableQueries});
        try {
            this.dbDialect.applyDdlStatements(connection, amendTableQueries);
        }
        catch (SQLException sqle) {
            if (maxRetries <= 0) {
                throw new ConnectException(String.format("Failed to amend table '%s' to add missing fields: %s", tableId, missingFields), (Throwable)sqle);
            }
            log.warn("Amend failed, re-attempting", (Throwable)sqle);
            this.tableDefns.refresh(connection, tableId);
            return this.amendIfNecessary(config, connection, tableId, fieldsMetadata, maxRetries - 1);
        }
        if (this.tableDefns.refresh(connection, tableId) == null) {
            throw new SQLException("Table with id " + tableId + "does not exist in database. Since we've either already auto-created the table or confirmed it existed before this point, it must mean this user does not have the permission to read the column data for this table.");
        }
        return true;
    }

    Set<SinkRecordField> missingFields(Collection<SinkRecordField> fields, Set<String> dbColumnNames) {
        HashSet<SinkRecordField> missingFields = new HashSet<SinkRecordField>();
        for (SinkRecordField sinkRecordField : fields) {
            if (dbColumnNames.contains(sinkRecordField.name())) continue;
            log.debug("Found missing field: {}", (Object)sinkRecordField);
            missingFields.add(sinkRecordField);
        }
        if (missingFields.isEmpty()) {
            return missingFields;
        }
        HashSet<String> columnNamesLowerCase = new HashSet<String>();
        for (String columnName : dbColumnNames) {
            columnNamesLowerCase.add(columnName.toLowerCase());
        }
        if (columnNamesLowerCase.size() != dbColumnNames.size()) {
            log.warn("Table has column names that differ only by case. Original columns={}", dbColumnNames);
        }
        HashSet<SinkRecordField> hashSet = new HashSet<SinkRecordField>();
        for (SinkRecordField missing : missingFields) {
            if (columnNamesLowerCase.contains(missing.name().toLowerCase())) continue;
            hashSet.add(missing);
        }
        if (hashSet.size() > 0) {
            log.info("Unable to find fields {} among column names {}", hashSet, dbColumnNames);
        }
        return hashSet;
    }

    protected TableDefinition tableDefinition(Connection connection, TableId tableId) throws SQLException {
        return this.tableDefns.get(connection, tableId);
    }
}

