/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TableDefinition {
    private final TableId id;
    private final Map<String, ColumnDefinition> columnsByName = new LinkedHashMap<String, ColumnDefinition>();
    private final Map<String, String> pkColumnNames = new LinkedHashMap<String, String>();

    public TableDefinition(TableId id, Iterable<ColumnDefinition> columns) {
        this.id = id;
        for (ColumnDefinition defn : columns) {
            String columnName = defn.id().name();
            this.columnsByName.put(columnName, defn.forTable(this.id));
            if (!defn.isPrimaryKey()) continue;
            this.pkColumnNames.put(columnName, columnName);
        }
    }

    public TableId id() {
        return this.id;
    }

    public int columnCount() {
        return this.columnsByName.size();
    }

    public ColumnDefinition definitionForColumn(String name) {
        return this.columnsByName.get(name);
    }

    public Collection<ColumnDefinition> definitionsForColumns() {
        return this.columnsByName.values();
    }

    public Collection<String> primaryKeyColumnNames() {
        return this.pkColumnNames.values();
    }

    public Set<String> columnNames() {
        return this.columnsByName.keySet();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof TableDefinition) {
            TableDefinition that = (TableDefinition)obj;
            return this.id.equals(that.id()) && this.definitionsForColumns().equals(that.definitionsForColumns());
        }
        return false;
    }

    public String toString() {
        return "Table{name='" + this.id + '\'' + ", columns=" + this.definitionsForColumns() + '}';
    }
}

