/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;

public class SapHanaDatabaseDialect
extends GenericDatabaseDialect {
    public SapHanaDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected String currentTimestampDatabaseQuery() {
        return "SELECT CURRENT_TIMESTAMP FROM DUMMY";
    }

    @Override
    protected String checkConnectionQuery() {
        return "SELECT DATABASE_NAME FROM SYS.M_DATABASES";
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "TINYINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INTEGER";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "REAL";
            }
            case FLOAT64: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR(1000)";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildCreateTableStatement(TableId table, Collection<SinkRecordField> fields) {
        return super.buildCreateTableStatement(table, fields).replace("CREATE TABLE", "CREATE COLUMN TABLE");
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD(");
        this.writeColumnsSpec(builder, fields);
        builder.append(")");
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("UPSERT ");
        builder.append(table);
        builder.append("(");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder.append(") VALUES(");
        builder.appendMultiple(",", "?", keyColumns.size() + nonKeyColumns.size());
        builder.append(")");
        builder.append(" WITH PRIMARY KEY");
        return builder.toString();
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(SapHanaDatabaseDialect.class.getSimpleName(), "sap");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new SapHanaDatabaseDialect(config);
        }
    }
}

