/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ExpressionBuilder;
import java.util.ArrayList;
import java.util.List;

public class IdentifierRules {
    public static final String UNSUPPORTED_QUOTE = " ";
    private static final String DEFAULT_QUOTE = "\"";
    private static final String DEFAULT_ID_DELIM = ".";
    public static final IdentifierRules DEFAULT = new IdentifierRules(".", "\"");
    private final String leadingQuoteString;
    private final String trailingQuoteString;
    private final String identifierDelimiter;

    public IdentifierRules(String quoteString) {
        this(DEFAULT_ID_DELIM, quoteString, quoteString);
    }

    public IdentifierRules(String delimiter, String quoteString) {
        this(delimiter, quoteString, quoteString);
    }

    public IdentifierRules(String identifierDelimiter, String leadingQuoteString, String trailingQuoteString) {
        this.leadingQuoteString = leadingQuoteString != null ? leadingQuoteString : DEFAULT_QUOTE;
        this.trailingQuoteString = trailingQuoteString != null ? trailingQuoteString : DEFAULT_QUOTE;
        this.identifierDelimiter = identifierDelimiter != null ? identifierDelimiter : DEFAULT_ID_DELIM;
    }

    public String identifierDelimiter() {
        return this.identifierDelimiter;
    }

    public String leadingQuoteString() {
        return this.leadingQuoteString;
    }

    public String trailingQuoteString() {
        return this.trailingQuoteString;
    }

    public ExpressionBuilder expressionBuilder() {
        return new ExpressionBuilder(this);
    }

    public List<String> parseQualifiedIdentifier(String fqn) {
        String orig = fqn;
        String delim = this.identifierDelimiter();
        String lead = this.leadingQuoteString();
        String trail = this.trailingQuoteString();
        ArrayList<String> parts = new ArrayList<String>();
        do {
            String segment;
            if (!lead.equals(UNSUPPORTED_QUOTE) && fqn.startsWith(lead)) {
                int end = fqn.indexOf(trail, lead.length());
                if (end < 0) {
                    throw new IllegalArgumentException("Failure parsing fully qualified identifier; missing trailing quote in " + orig);
                }
                segment = fqn.substring(lead.length(), end);
                if ((fqn = fqn.substring(end + trail.length())).startsWith(delim) && (fqn = fqn.substring(delim.length())).isEmpty()) {
                    throw new IllegalArgumentException("Failure parsing fully qualified identifier; ends in delimiter " + orig);
                }
            } else {
                int index = fqn.indexOf(delim, 0);
                if (index == -1) {
                    segment = fqn;
                    fqn = "";
                } else {
                    segment = fqn.substring(0, index);
                    if ((fqn = fqn.substring(index + delim.length())).isEmpty()) {
                        throw new IllegalArgumentException("Failure parsing fully qualified identifier; ends in delimiter " + orig);
                    }
                }
            }
            parts.add(segment);
        } while (fqn.length() > 0);
        return parts;
    }

    public IdentifierRules escapeQuotesWith(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this;
        }
        return new IdentifierRules(this.identifierDelimiter, prefix + this.leadingQuoteString, prefix + this.trailingQuoteString);
    }
}

