/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.OffsetProtocols;
import io.confluent.connect.jdbc.source.SchemaMapping;
import io.confluent.connect.jdbc.source.TableQuerier;
import io.confluent.connect.jdbc.source.TimestampIncrementingCriteria;
import io.confluent.connect.jdbc.source.TimestampIncrementingOffset;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampIncrementingTableQuerier
extends TableQuerier
implements TimestampIncrementingCriteria.CriteriaValues {
    private static final Logger log = LoggerFactory.getLogger(TimestampIncrementingTableQuerier.class);
    private final List<String> timestampColumnNames;
    private final List<ColumnId> timestampColumns;
    private String incrementingColumnName;
    private long timestampDelay;
    private TimestampIncrementingOffset offset;
    private TimestampIncrementingCriteria criteria;
    private final Map<String, String> partition;
    private final String topic;
    private final TimeZone timeZone;

    public TimestampIncrementingTableQuerier(DatabaseDialect dialect, TableQuerier.QueryMode mode, String name, String topicPrefix, List<String> timestampColumnNames, String incrementingColumnName, Map<String, Object> offsetMap, Long timestampDelay, TimeZone timeZone, String suffix) {
        super(dialect, mode, name, topicPrefix, suffix);
        this.incrementingColumnName = incrementingColumnName;
        this.timestampColumnNames = timestampColumnNames != null ? timestampColumnNames : Collections.emptyList();
        this.timestampDelay = timestampDelay;
        this.offset = TimestampIncrementingOffset.fromMap(offsetMap);
        this.timestampColumns = new ArrayList<ColumnId>();
        for (String timestampColumn : this.timestampColumnNames) {
            if (timestampColumn == null || timestampColumn.isEmpty()) continue;
            this.timestampColumns.add(new ColumnId(this.tableId, timestampColumn));
        }
        switch (mode) {
            case TABLE: {
                String tableName = this.tableId.tableName();
                this.topic = topicPrefix + tableName;
                this.partition = OffsetProtocols.sourcePartitionForProtocolV1(this.tableId);
                break;
            }
            case QUERY: {
                this.partition = Collections.singletonMap("query", "query");
                this.topic = topicPrefix;
                break;
            }
            default: {
                throw new ConnectException("Unexpected query mode: " + (Object)((Object)mode));
            }
        }
        this.timeZone = timeZone;
    }

    @Override
    protected void createPreparedStatement(Connection db) throws SQLException {
        this.findDefaultAutoIncrementingColumn(db);
        ColumnId incrementingColumn = null;
        if (this.incrementingColumnName != null && !this.incrementingColumnName.isEmpty()) {
            incrementingColumn = new ColumnId(this.tableId, this.incrementingColumnName);
        }
        ExpressionBuilder builder = this.dialect.expressionBuilder();
        switch (this.mode) {
            case TABLE: {
                builder.append("SELECT * FROM ");
                builder.append(this.tableId);
                break;
            }
            case QUERY: {
                builder.append(this.query);
                break;
            }
            default: {
                throw new ConnectException("Unknown mode encountered when preparing query: " + (Object)((Object)this.mode));
            }
        }
        this.criteria = this.dialect.criteriaFor(incrementingColumn, this.timestampColumns);
        this.criteria.whereClause(builder);
        this.addSuffixIfPresent(builder);
        String queryString = builder.toString();
        this.recordQuery(queryString);
        log.debug("{} prepared SQL query: {}", (Object)this, (Object)queryString);
        this.stmt = this.dialect.createPreparedStatement(db, queryString);
    }

    private void findDefaultAutoIncrementingColumn(Connection db) throws SQLException {
        if (this.incrementingColumnName != null && this.incrementingColumnName.isEmpty()) {
            for (ColumnDefinition defn : this.dialect.describeColumns(db, this.tableId.catalogName(), this.tableId.schemaName(), this.tableId.tableName(), null).values()) {
                if (!defn.isAutoIncrement()) continue;
                this.incrementingColumnName = defn.id().name();
                break;
            }
        }
        if (this.incrementingColumnName != null && this.incrementingColumnName.isEmpty()) {
            log.debug("Falling back to describe '{}' table by querying {}", (Object)this.tableId, (Object)db);
            for (ColumnDefinition defn : this.dialect.describeColumnsByQuerying(db, this.tableId).values()) {
                if (!defn.isAutoIncrement()) continue;
                this.incrementingColumnName = defn.id().name();
                break;
            }
        }
    }

    @Override
    protected ResultSet executeQuery() throws SQLException {
        this.criteria.setQueryParameters(this.stmt, this);
        log.trace("Statement to execute: {}", (Object)this.stmt.toString());
        return this.stmt.executeQuery();
    }

    @Override
    public SourceRecord extractRecord() throws SQLException {
        Struct record = new Struct(this.schemaMapping.schema());
        for (SchemaMapping.FieldSetter setter : this.schemaMapping.fieldSetters()) {
            try {
                setter.setField(record, this.resultSet);
            }
            catch (IOException e) {
                log.warn("Error mapping fields into Connect record", (Throwable)e);
                throw new ConnectException((Throwable)e);
            }
            catch (SQLException e) {
                log.warn("SQL error mapping fields into Connect record", (Throwable)e);
                throw new DataException((Throwable)e);
            }
        }
        this.offset = this.criteria.extractValues(this.schemaMapping.schema(), record, this.offset);
        return new SourceRecord(this.partition, this.offset.toMap(), this.topic, record.schema(), (Object)record);
    }

    @Override
    public Timestamp beginTimetampValue() {
        return this.offset.getTimestampOffset();
    }

    @Override
    public Timestamp endTimetampValue() throws SQLException {
        long currentDbTime = this.dialect.currentTimeOnDB(this.stmt.getConnection(), DateTimeUtils.getTimeZoneCalendar(this.timeZone)).getTime();
        return new Timestamp(currentDbTime - this.timestampDelay);
    }

    @Override
    public Long lastIncrementedValue() {
        return this.offset.getIncrementingOffset();
    }

    public String toString() {
        return "TimestampIncrementingTableQuerier{table=" + this.tableId + ", query='" + this.query + '\'' + ", topicPrefix='" + this.topicPrefix + '\'' + ", incrementingColumn='" + (this.incrementingColumnName != null ? this.incrementingColumnName : "") + '\'' + ", timestampColumns=" + this.timestampColumnNames + '}';
    }
}

