/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DatabaseDialects;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.PreparedStatementBinder;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.source.JdbcSourceTaskConfig;
import io.confluent.connect.jdbc.source.TimestampIncrementingCriteria;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.JdbcDriverInfo;
import io.confluent.connect.jdbc.util.QuoteMethod;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import io.confluent.connect.jdbc.util.TableType;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDatabaseDialect
implements DatabaseDialect {
    protected static final int NUMERIC_TYPE_SCALE_LOW = -84;
    protected static final int NUMERIC_TYPE_SCALE_HIGH = 127;
    protected static final int NUMERIC_TYPE_SCALE_UNSET = -127;
    private static final Logger glog = LoggerFactory.getLogger(GenericDatabaseDialect.class);
    @Deprecated
    protected final Logger log = LoggerFactory.getLogger(GenericDatabaseDialect.class);
    protected final AbstractConfig config;
    protected final JdbcSourceConnectorConfig.NumericMapping mapNumerics;
    protected String catalogPattern;
    protected final String schemaPattern;
    protected final Set<String> tableTypes;
    protected final String jdbcUrl;
    protected final DatabaseDialectProvider.JdbcUrlInfo jdbcUrlInfo;
    private final QuoteMethod quoteSqlIdentifiers;
    private final IdentifierRules defaultIdentifierRules;
    private final AtomicReference<IdentifierRules> identifierRules = new AtomicReference();
    private final Queue<Connection> connections = new ConcurrentLinkedQueue<Connection>();
    private volatile JdbcDriverInfo jdbcDriverInfo;
    private final int batchMaxRows;
    private final TimeZone timeZone;

    public GenericDatabaseDialect(AbstractConfig config) {
        this(config, IdentifierRules.DEFAULT);
    }

    protected GenericDatabaseDialect(AbstractConfig config, IdentifierRules defaultIdentifierRules) {
        this.config = config;
        this.defaultIdentifierRules = defaultIdentifierRules;
        this.jdbcUrl = config.getString("connection.url");
        this.jdbcUrlInfo = DatabaseDialects.extractJdbcUrlInfo(this.jdbcUrl);
        if (config instanceof JdbcSinkConfig) {
            JdbcSinkConfig sinkConfig = (JdbcSinkConfig)config;
            this.catalogPattern = JdbcSourceTaskConfig.CATALOG_PATTERN_DEFAULT;
            this.schemaPattern = JdbcSourceTaskConfig.SCHEMA_PATTERN_DEFAULT;
            this.tableTypes = sinkConfig.tableTypeNames();
            this.quoteSqlIdentifiers = QuoteMethod.get(config.getString("quote.sql.identifiers"));
        } else {
            this.catalogPattern = config.getString("catalog.pattern");
            this.schemaPattern = config.getString("schema.pattern");
            this.tableTypes = new HashSet<String>(config.getList("table.types"));
            this.quoteSqlIdentifiers = QuoteMethod.get(config.getString("quote.sql.identifiers"));
        }
        if (config instanceof JdbcSourceConnectorConfig) {
            this.mapNumerics = ((JdbcSourceConnectorConfig)config).numericMapping();
            this.batchMaxRows = config.getInt("batch.max.rows");
        } else {
            this.mapNumerics = JdbcSourceConnectorConfig.NumericMapping.NONE;
            this.batchMaxRows = 0;
        }
        this.timeZone = config instanceof JdbcSourceConnectorConfig ? ((JdbcSourceConnectorConfig)config).timeZone() : (config instanceof JdbcSinkConfig ? ((JdbcSinkConfig)config).timeZone : TimeZone.getTimeZone(ZoneOffset.UTC));
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName().replace("DatabaseDialect", "");
    }

    protected TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    public Connection getConnection() throws SQLException {
        String username = this.config.getString("connection.user");
        Password dbPassword = this.config.getPassword("connection.password");
        Properties properties = new Properties();
        if (username != null) {
            properties.setProperty("user", username);
        }
        if (dbPassword != null) {
            properties.setProperty("password", dbPassword.value());
        }
        properties = this.addConnectionProperties(properties);
        DriverManager.setLoginTimeout(40);
        Connection connection = DriverManager.getConnection(this.jdbcUrl, properties);
        if (this.jdbcDriverInfo == null) {
            this.jdbcDriverInfo = this.createJdbcDriverInfo(connection);
        }
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void close() {
        Connection conn;
        while ((conn = this.connections.poll()) != null) {
            try {
                conn.close();
            }
            catch (Throwable e) {
                glog.warn("Error while closing connection to {}", (Object)this.jdbcDriverInfo, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionValid(Connection connection, int timeout) throws SQLException {
        block18: {
            if (this.jdbcDriverInfo().jdbcMajorVersion() >= 4) {
                return connection.isValid(timeout);
            }
            String query = this.checkConnectionQuery();
            if (query != null) {
                try (Statement statement = connection.createStatement();){
                    if (!statement.execute(query)) break block18;
                    try (ResultSet rs = null;){
                        rs = statement.getResultSet();
                    }
                }
            }
        }
        return true;
    }

    protected String checkConnectionQuery() {
        return "SELECT 1";
    }

    protected JdbcDriverInfo jdbcDriverInfo() {
        if (this.jdbcDriverInfo == null) {
            try (Connection connection = this.getConnection();){
                this.jdbcDriverInfo = this.createJdbcDriverInfo(connection);
            }
            catch (SQLException e) {
                throw new ConnectException("Unable to get JDBC driver information", (Throwable)e);
            }
        }
        return this.jdbcDriverInfo;
    }

    protected JdbcDriverInfo createJdbcDriverInfo(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return new JdbcDriverInfo(metadata.getJDBCMajorVersion(), metadata.getJDBCMinorVersion(), metadata.getDriverName(), metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion());
    }

    protected Properties addConnectionProperties(Properties properties) {
        return properties;
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection db, String query) throws SQLException {
        glog.trace("Creating a PreparedStatement '{}'", (Object)query);
        PreparedStatement stmt = db.prepareStatement(query);
        this.initializePreparedStatement(stmt);
        return stmt;
    }

    protected void initializePreparedStatement(PreparedStatement stmt) throws SQLException {
        if (this.batchMaxRows > 0) {
            stmt.setFetchSize(this.batchMaxRows);
        }
    }

    @Override
    public TableId parseTableIdentifier(String fqn) {
        List<String> parts = this.identifierRules().parseQualifiedIdentifier(fqn);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Invalid fully qualified name: '" + fqn + "'");
        }
        if (parts.size() == 1) {
            return new TableId(null, null, parts.get(0));
        }
        if (parts.size() == 3) {
            return new TableId(parts.get(0), parts.get(1), parts.get(2));
        }
        assert (parts.size() >= 2);
        if (this.useCatalog()) {
            return new TableId(parts.get(0), null, parts.get(1));
        }
        return new TableId(null, parts.get(0), parts.get(1));
    }

    protected boolean useCatalog() {
        return false;
    }

    @Override
    public List<TableId> tableIds(Connection conn) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        String[] tableTypes = this.tableTypes(metadata, this.tableTypes);
        String tableTypeDisplay = this.displayableTableTypes(tableTypes, ", ");
        glog.debug("Using {} dialect to get {}", (Object)this, (Object)tableTypeDisplay);
        try (ResultSet rs = metadata.getTables(this.catalogPattern(), this.schemaPattern(), "%", tableTypes);){
            ArrayList<TableId> tableIds = new ArrayList<TableId>();
            while (rs.next()) {
                String tableName;
                String schemaName;
                String catalogName = rs.getString(1);
                TableId tableId = new TableId(catalogName, schemaName = rs.getString(2), tableName = rs.getString(3));
                if (!this.includeTable(tableId)) continue;
                tableIds.add(tableId);
            }
            glog.debug("Used {} dialect to find {} {}", new Object[]{this, tableIds.size(), tableTypeDisplay});
            ArrayList<TableId> arrayList = tableIds;
            return arrayList;
        }
    }

    protected String catalogPattern() {
        return this.catalogPattern;
    }

    protected String schemaPattern() {
        return this.schemaPattern;
    }

    protected boolean includeTable(TableId table) {
        return true;
    }

    protected String[] tableTypes(DatabaseMetaData metadata, Set<String> types) throws SQLException {
        glog.debug("Using {} dialect to check support for {}", (Object)this, types);
        HashSet<String> uppercaseTypes = new HashSet<String>();
        for (String type : types) {
            if (type == null) continue;
            uppercaseTypes.add(type.toUpperCase(Locale.ROOT));
        }
        HashSet<String> matchingTableTypes = new HashSet<String>();
        try (ResultSet rs = metadata.getTableTypes();){
            while (rs.next()) {
                String tableType = rs.getString(1);
                if (tableType == null || !uppercaseTypes.contains(tableType.toUpperCase(Locale.ROOT))) continue;
                matchingTableTypes.add(tableType);
            }
        }
        String[] result = matchingTableTypes.toArray(new String[matchingTableTypes.size()]);
        glog.debug("Used {} dialect to find table types: {}", (Object)this, (Object)result);
        return result;
    }

    @Override
    public IdentifierRules identifierRules() {
        if (this.identifierRules.get() == null) {
            try (Connection connection = this.getConnection();){
                String leadingQuoteStr;
                DatabaseMetaData metaData = connection.getMetaData();
                String trailingQuoteStr = leadingQuoteStr = metaData.getIdentifierQuoteString();
                String separator = metaData.getCatalogSeparator();
                if (leadingQuoteStr == null || leadingQuoteStr.isEmpty()) {
                    leadingQuoteStr = this.defaultIdentifierRules.leadingQuoteString();
                    trailingQuoteStr = this.defaultIdentifierRules.trailingQuoteString();
                }
                if (separator == null || separator.isEmpty()) {
                    separator = this.defaultIdentifierRules.identifierDelimiter();
                }
                this.identifierRules.set(new IdentifierRules(separator, leadingQuoteStr, trailingQuoteStr));
            }
            catch (SQLException e) {
                if (this.defaultIdentifierRules != null) {
                    this.identifierRules.set(this.defaultIdentifierRules);
                    glog.warn("Unable to get identifier metadata; using default rules", (Throwable)e);
                }
                throw new ConnectException("Unable to get identifier metadata", (Throwable)e);
            }
        }
        return this.identifierRules.get();
    }

    @Override
    public ExpressionBuilder expressionBuilder() {
        return this.identifierRules().expressionBuilder().setQuoteIdentifiers(this.quoteSqlIdentifiers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.sql.Timestamp currentTimeOnDB(Connection conn, Calendar cal) throws SQLException, ConnectException {
        String query = this.currentTimestampDatabaseQuery();
        assert (query != null);
        assert (!query.isEmpty());
        try (Statement stmt = conn.createStatement();){
            Throwable throwable;
            ResultSet rs;
            block27: {
                java.sql.Timestamp timestamp;
                block28: {
                    glog.debug("executing query " + query + " to get current time from database");
                    rs = stmt.executeQuery(query);
                    throwable = null;
                    if (!rs.next()) break block27;
                    timestamp = rs.getTimestamp(1, cal);
                    if (rs == null) return timestamp;
                    if (throwable == null) break block28;
                    try {
                        rs.close();
                        return timestamp;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return timestamp;
                    }
                }
                rs.close();
                return timestamp;
            }
            try {
                try {
                    throw new ConnectException("Unable to get current time from DB using " + this + " and query '" + query + "'");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (rs == null) throw throwable4;
                if (throwable == null) {
                    rs.close();
                    throw throwable4;
                }
                try {
                    rs.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (SQLException e) {
            glog.error("Failed to get current time from DB using {} and query '{}'", new Object[]{this, query, e});
            throw e;
        }
    }

    protected String currentTimestampDatabaseQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    public boolean tableExists(Connection connection, TableId tableId) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String[] tableTypes = this.tableTypes(metadata, this.tableTypes);
        String tableTypeDisplay = this.displayableTableTypes(tableTypes, "/");
        glog.info("Checking {} dialect for existence of {} {}", new Object[]{this, tableTypeDisplay, tableId});
        try (ResultSet rs = connection.getMetaData().getTables(tableId.catalogName(), tableId.schemaName(), tableId.tableName(), tableTypes);){
            boolean exists = rs.next();
            glog.info("Using {} dialect {} {} {}", new Object[]{this, tableTypeDisplay, tableId, exists ? "present" : "absent"});
            boolean bl = exists;
            return bl;
        }
    }

    protected String displayableTableTypes(String[] types, String delim) {
        return Arrays.stream(types).sorted().collect(Collectors.joining(delim));
    }

    @Override
    public Map<ColumnId, ColumnDefinition> describeColumns(Connection connection, String tablePattern, String columnPattern) throws SQLException {
        TableId tableId = this.parseTableIdentifier(tablePattern);
        String catalog = tableId.catalogName() != null ? tableId.catalogName() : this.catalogPattern;
        String schema = tableId.schemaName() != null ? tableId.schemaName() : this.schemaPattern;
        return this.describeColumns(connection, catalog, schema, tableId.tableName(), columnPattern);
    }

    @Override
    public Map<ColumnId, ColumnDefinition> describeColumns(Connection connection, String catalogPattern, String schemaPattern, String tablePattern, String columnPattern) throws SQLException {
        glog.debug("Querying {} dialect column metadata for catalog:{} schema:{} table:{}", new Object[]{this, catalogPattern, schemaPattern, tablePattern});
        Set<ColumnId> pkColumns = this.primaryKeyColumns(connection, catalogPattern, schemaPattern, tablePattern);
        HashMap<ColumnId, ColumnDefinition> results = new HashMap<ColumnId, ColumnDefinition>();
        try (ResultSet rs = connection.getMetaData().getColumns(catalogPattern, schemaPattern, tablePattern, columnPattern);){
            int rsColumnCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                ColumnDefinition.Nullability nullability;
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName = rs.getString(3);
                TableId tableId = new TableId(catalogName, schemaName, tableName);
                String columnName = rs.getString(4);
                ColumnId columnId = new ColumnId(tableId, columnName, null);
                int jdbcType = rs.getInt(5);
                String typeName = rs.getString(6);
                int precision = rs.getInt(7);
                int scale = rs.getInt(9);
                String typeClassName = null;
                int nullableValue = rs.getInt(11);
                switch (nullableValue) {
                    case 0: {
                        nullability = ColumnDefinition.Nullability.NOT_NULL;
                        break;
                    }
                    case 1: {
                        nullability = ColumnDefinition.Nullability.NULL;
                        break;
                    }
                    default: {
                        nullability = ColumnDefinition.Nullability.UNKNOWN;
                    }
                }
                Boolean autoIncremented = null;
                if (rsColumnCount >= 23) {
                    String isAutoIncremented = rs.getString(23);
                    if ("yes".equalsIgnoreCase(isAutoIncremented)) {
                        autoIncremented = Boolean.TRUE;
                    } else if ("no".equalsIgnoreCase(isAutoIncremented)) {
                        autoIncremented = Boolean.FALSE;
                    }
                }
                Boolean signed = null;
                Boolean caseSensitive = null;
                Boolean searchable = null;
                Boolean currency = null;
                Integer displaySize = null;
                boolean isPrimaryKey = pkColumns.contains(columnId);
                if (isPrimaryKey) {
                    nullability = ColumnDefinition.Nullability.NOT_NULL;
                }
                ColumnDefinition defn = this.columnDefinition(rs, columnId, jdbcType, typeName, typeClassName, nullability, ColumnDefinition.Mutability.UNKNOWN, precision, scale, signed, displaySize, autoIncremented, caseSensitive, searchable, currency, isPrimaryKey);
                results.put(columnId, defn);
            }
            HashMap<ColumnId, ColumnDefinition> hashMap = results;
            return hashMap;
        }
    }

    @Override
    public Map<ColumnId, ColumnDefinition> describeColumns(ResultSetMetaData rsMetadata) throws SQLException {
        LinkedHashMap<ColumnId, ColumnDefinition> result = new LinkedHashMap<ColumnId, ColumnDefinition>();
        for (int i = 1; i <= rsMetadata.getColumnCount(); ++i) {
            ColumnDefinition defn = this.describeColumn(rsMetadata, i);
            result.put(defn.id(), defn);
        }
        return result;
    }

    protected ColumnDefinition describeColumn(ResultSetMetaData rsMetadata, int column) throws SQLException {
        ColumnDefinition.Nullability nullability;
        String catalog = rsMetadata.getCatalogName(column);
        String schema = rsMetadata.getSchemaName(column);
        String tableName = rsMetadata.getTableName(column);
        TableId tableId = new TableId(catalog, schema, tableName);
        String name = rsMetadata.getColumnName(column);
        String alias = rsMetadata.getColumnLabel(column);
        ColumnId id = new ColumnId(tableId, name, alias);
        switch (rsMetadata.isNullable(column)) {
            case 1: {
                nullability = ColumnDefinition.Nullability.NULL;
                break;
            }
            case 0: {
                nullability = ColumnDefinition.Nullability.NOT_NULL;
                break;
            }
            default: {
                nullability = ColumnDefinition.Nullability.UNKNOWN;
            }
        }
        ColumnDefinition.Mutability mutability = ColumnDefinition.Mutability.MAYBE_WRITABLE;
        if (rsMetadata.isReadOnly(column)) {
            mutability = ColumnDefinition.Mutability.READ_ONLY;
        } else if (rsMetadata.isWritable(column)) {
            mutability = ColumnDefinition.Mutability.MAYBE_WRITABLE;
        } else if (rsMetadata.isDefinitelyWritable(column)) {
            mutability = ColumnDefinition.Mutability.WRITABLE;
        }
        return new ColumnDefinition(id, rsMetadata.getColumnType(column), rsMetadata.getColumnTypeName(column), rsMetadata.getColumnClassName(column), nullability, mutability, rsMetadata.getPrecision(column), rsMetadata.getScale(column), rsMetadata.isSigned(column), rsMetadata.getColumnDisplaySize(column), rsMetadata.isAutoIncrement(column), rsMetadata.isCaseSensitive(column), rsMetadata.isSearchable(column), rsMetadata.isCurrency(column), false);
    }

    protected Set<ColumnId> primaryKeyColumns(Connection connection, String catalogPattern, String schemaPattern, String tablePattern) throws SQLException {
        HashSet<ColumnId> pkColumns = new HashSet<ColumnId>();
        try (ResultSet rs = connection.getMetaData().getPrimaryKeys(catalogPattern, schemaPattern, tablePattern);){
            while (rs.next()) {
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName = rs.getString(3);
                TableId tableId = new TableId(catalogName, schemaName, tableName);
                String colName = rs.getString(4);
                ColumnId columnId = new ColumnId(tableId, colName);
                pkColumns.add(columnId);
            }
        }
        return pkColumns;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<ColumnId, ColumnDefinition> describeColumnsByQuerying(Connection db, TableId tableId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public TableDefinition describeTable(Connection connection, TableId tableId) throws SQLException {
        Map<ColumnId, ColumnDefinition> columnDefns = this.describeColumns(connection, tableId.catalogName(), tableId.schemaName(), tableId.tableName(), null);
        if (columnDefns.isEmpty()) {
            return null;
        }
        TableType tableType = this.tableTypeFor(connection, tableId);
        return new TableDefinition(tableId, columnDefns.values(), tableType);
    }

    /*
     * Loose catch block
     */
    protected TableType tableTypeFor(Connection connection, TableId tableId) throws SQLException {
        String tableTypeDisplay;
        block19: {
            DatabaseMetaData metadata = connection.getMetaData();
            String[] tableTypes = this.tableTypes(metadata, this.tableTypes);
            tableTypeDisplay = this.displayableTableTypes(tableTypes, "/");
            glog.info("Checking {} dialect for type of {} {}", new Object[]{this, tableTypeDisplay, tableId});
            Throwable throwable = null;
            try (ResultSet rs = connection.getMetaData().getTables(tableId.catalogName(), tableId.schemaName(), tableId.tableName(), tableTypes);){
                if (!rs.next()) break block19;
                String tableType = rs.getString(4);
                try {
                    TableType tableType2 = TableType.get(tableType);
                    return tableType2;
                }
                catch (IllegalArgumentException e) {
                    TableType tableType3;
                    block20: {
                        block21: {
                            glog.warn("{} dialect found unknown type '{}' for {} {}; using TABLE", new Object[]{this, tableType, tableTypeDisplay, tableId});
                            tableType3 = TableType.TABLE;
                            if (rs == null) break block20;
                            if (throwable == null) break block21;
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block20;
                        }
                        rs.close();
                    }
                    return tableType3;
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        glog.warn("{} dialect did not find type for {} {}; using TABLE", new Object[]{this, tableTypeDisplay, tableId});
        return TableType.TABLE;
    }

    protected ColumnDefinition columnDefinition(ResultSet resultSet, ColumnId id, int jdbcType, String typeName, String classNameForType, ColumnDefinition.Nullability nullability, ColumnDefinition.Mutability mutability, int precision, int scale, Boolean signedNumbers, Integer displaySize, Boolean autoIncremented, Boolean caseSensitive, Boolean searchable, Boolean currency, Boolean isPrimaryKey) {
        return new ColumnDefinition(id, jdbcType, typeName, classNameForType, nullability, mutability, precision, scale, signedNumbers != null ? signedNumbers : false, displaySize != null ? displaySize : 0, autoIncremented != null ? autoIncremented : false, caseSensitive != null ? caseSensitive : false, searchable != null ? searchable : false, currency != null ? currency : false, isPrimaryKey != null ? isPrimaryKey : false);
    }

    @Override
    public TimestampIncrementingCriteria criteriaFor(ColumnId incrementingColumn, List<ColumnId> timestampColumns) {
        return new TimestampIncrementingCriteria(incrementingColumn, timestampColumns, this.timeZone);
    }

    protected String fieldNameFor(ColumnDefinition columnDefinition) {
        return columnDefinition.id().aliasOrName();
    }

    @Override
    public String addFieldToSchema(ColumnDefinition columnDefn, SchemaBuilder builder) {
        return this.addFieldToSchema(columnDefn, builder, this.fieldNameFor(columnDefn), columnDefn.type(), columnDefn.isOptional());
    }

    /*
     * Unable to fully structure code
     */
    protected String addFieldToSchema(ColumnDefinition columnDefn, SchemaBuilder builder, String fieldName, int sqlType, boolean optional) {
        precision = columnDefn.precision();
        scale = columnDefn.scale();
        switch (sqlType) {
            case 0: {
                GenericDatabaseDialect.glog.debug("JDBC type 'NULL' not currently supported for column '{}'", (Object)fieldName);
                return null;
            }
            case 16: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_BOOLEAN_SCHEMA : Schema.BOOLEAN_SCHEMA);
                break;
            }
            case -7: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA);
                break;
            }
            case -6: {
                if (columnDefn.isSignedNumber()) {
                    builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA);
                    break;
                }
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT16_SCHEMA : Schema.INT16_SCHEMA);
                break;
            }
            case 5: {
                if (columnDefn.isSignedNumber()) {
                    builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT16_SCHEMA : Schema.INT16_SCHEMA);
                    break;
                }
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT32_SCHEMA : Schema.INT32_SCHEMA);
                break;
            }
            case 4: {
                if (columnDefn.isSignedNumber()) {
                    builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT32_SCHEMA : Schema.INT32_SCHEMA);
                    break;
                }
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA);
                break;
            }
            case -5: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA);
                break;
            }
            case 7: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_FLOAT32_SCHEMA : Schema.FLOAT32_SCHEMA);
                break;
            }
            case 6: 
            case 8: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_FLOAT64_SCHEMA : Schema.FLOAT64_SCHEMA);
                break;
            }
            case 2: {
                if (this.mapNumerics != JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY) ** GOTO lbl60
                GenericDatabaseDialect.glog.debug("NUMERIC with precision: '{}' and scale: '{}'", (Object)precision, (Object)scale);
                if (scale == 0 && precision < 19) {
                    schema = precision > 9 ? (optional != false ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA) : (precision > 4 ? (optional != false ? Schema.OPTIONAL_INT32_SCHEMA : Schema.INT32_SCHEMA) : (precision > 2 ? (optional != false ? Schema.OPTIONAL_INT16_SCHEMA : Schema.INT16_SCHEMA) : (optional != false ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA)));
                    builder.field(fieldName, schema);
                    break;
                }
                ** GOTO lbl73
lbl60:
                // 1 sources

                if (this.mapNumerics == JdbcSourceConnectorConfig.NumericMapping.BEST_FIT) {
                    GenericDatabaseDialect.glog.debug("NUMERIC with precision: '{}' and scale: '{}'", (Object)precision, (Object)scale);
                    if (precision < 19) {
                        if (scale < 1 && scale >= -84) {
                            schema = precision > 9 ? (optional != false ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA) : (precision > 4 ? (optional != false ? Schema.OPTIONAL_INT32_SCHEMA : Schema.INT32_SCHEMA) : (precision > 2 ? (optional != false ? Schema.OPTIONAL_INT16_SCHEMA : Schema.INT16_SCHEMA) : (optional != false ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA)));
                            builder.field(fieldName, schema);
                            break;
                        }
                        if (scale > 0) {
                            schema = optional != false ? Schema.OPTIONAL_FLOAT64_SCHEMA : Schema.FLOAT64_SCHEMA;
                            builder.field(fieldName, schema);
                            break;
                        }
                    }
                }
            }
lbl73:
            // 8 sources

            case 3: {
                GenericDatabaseDialect.glog.debug("DECIMAL with precision: '{}' and scale: '{}'", (Object)precision, (Object)scale);
                scale = this.decimalScale(columnDefn);
                fieldBuilder = Decimal.builder((int)scale);
                if (optional) {
                    fieldBuilder.optional();
                }
                builder.field(fieldName, fieldBuilder.build());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                builder.field(fieldName, optional != false ? Schema.OPTIONAL_BYTES_SCHEMA : Schema.BYTES_SCHEMA);
                break;
            }
            case 91: {
                dateSchemaBuilder = Date.builder();
                if (optional) {
                    dateSchemaBuilder.optional();
                }
                builder.field(fieldName, dateSchemaBuilder.build());
                break;
            }
            case 92: {
                timeSchemaBuilder = Time.builder();
                if (optional) {
                    timeSchemaBuilder.optional();
                }
                builder.field(fieldName, timeSchemaBuilder.build());
                break;
            }
            case 93: {
                tsSchemaBuilder = Timestamp.builder();
                if (optional) {
                    tsSchemaBuilder.optional();
                }
                builder.field(fieldName, tsSchemaBuilder.build());
                break;
            }
            default: {
                GenericDatabaseDialect.glog.warn("JDBC type {} ({}) not currently supported", (Object)sqlType, (Object)columnDefn.typeName());
                return null;
            }
        }
        return fieldName;
    }

    @Override
    public void applyDdlStatements(Connection connection, List<String> statements) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String ddlStatement : statements) {
                statement.executeUpdate(ddlStatement);
            }
        }
    }

    @Override
    public DatabaseDialect.ColumnConverter createColumnConverter(ColumnMapping mapping) {
        return this.columnConverterFor(mapping, mapping.columnDefn(), mapping.columnNumber(), this.jdbcDriverInfo().jdbcVersionAtLeast(4, 0));
    }

    /*
     * Unable to fully structure code
     */
    protected DatabaseDialect.ColumnConverter columnConverterFor(ColumnMapping mapping, ColumnDefinition defn, int col, boolean isJdbc4) {
        switch (mapping.columnDefn().type()) {
            case 16: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$0(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case -7: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$1(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case -6: {
                if (defn.isSignedNumber()) {
                    return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$2(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                }
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$3(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 5: {
                if (defn.isSignedNumber()) {
                    return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$4(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                }
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$5(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 4: {
                if (defn.isSignedNumber()) {
                    return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$6(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                }
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$7(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case -5: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$8(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 7: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$9(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 6: 
            case 8: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$10(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 2: {
                if (this.mapNumerics != JdbcSourceConnectorConfig.NumericMapping.PRECISION_ONLY) ** GOTO lbl38
                precision = defn.precision();
                scale = defn.scale();
                GenericDatabaseDialect.glog.trace("NUMERIC with precision: '{}' and scale: '{}'", (Object)precision, (Object)scale);
                if (scale == 0 && precision < 19) {
                    if (precision > 9) {
                        return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$11(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                    }
                    if (precision > 4) {
                        return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$12(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                    }
                    if (precision > 2) {
                        return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$13(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                    }
                    return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$14(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                }
                ** GOTO lbl53
lbl38:
                // 1 sources

                if (this.mapNumerics == JdbcSourceConnectorConfig.NumericMapping.BEST_FIT) {
                    precision = defn.precision();
                    scale = defn.scale();
                    GenericDatabaseDialect.glog.trace("NUMERIC with precision: '{}' and scale: '{}'", (Object)precision, (Object)scale);
                    if (precision < 19) {
                        if (scale < 1 && scale >= -84) {
                            if (precision > 9) {
                                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$15(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                            }
                            if (precision > 4) {
                                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$16(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                            }
                            if (precision > 2) {
                                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$17(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                            }
                            return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$18(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                        }
                        if (scale > 0) {
                            return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$19(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
                        }
                    }
                }
            }
lbl53:
            // 8 sources

            case 3: {
                precision = defn.precision();
                GenericDatabaseDialect.glog.debug("DECIMAL with precision: '{}' and scale: '{}'", (Object)precision, (Object)defn.scale());
                scale = this.decimalScale(defn);
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$20(int int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col, (int)scale);
            }
            case -1: 
            case 1: 
            case 12: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$21(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case -16: 
            case -15: 
            case -9: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$22(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case -4: 
            case -3: 
            case -2: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$23(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 91: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$24(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 92: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$25(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((GenericDatabaseDialect)this, (int)col);
            }
            case 93: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$26(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((GenericDatabaseDialect)this, (int)col);
            }
            case 70: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$27(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
            case 2004: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$28(int boolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((GenericDatabaseDialect)this, (int)col, (boolean)isJdbc4);
            }
            case 2005: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$29(int boolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((GenericDatabaseDialect)this, (int)col, (boolean)isJdbc4);
            }
            case 2011: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$30(int boolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((GenericDatabaseDialect)this, (int)col, (boolean)isJdbc4);
            }
            case 2009: {
                return (DatabaseDialect.ColumnConverter)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)Ljava/lang/Object;, lambda$columnConverterFor$31(int java.sql.ResultSet ), (Ljava/sql/ResultSet;)Ljava/lang/Object;)((int)col);
            }
        }
        return null;
    }

    protected int decimalScale(ColumnDefinition defn) {
        return defn.scale() == -127 ? 127 : defn.scale();
    }

    protected void free(Blob blob) throws SQLException {
        blob.free();
    }

    protected void free(Clob clob) throws SQLException {
        clob.free();
    }

    @Override
    public String buildInsertStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("INSERT INTO ");
        builder.append(table);
        builder.append("(");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder.append(") VALUES(");
        builder.appendMultiple(",", "?", keyColumns.size() + nonKeyColumns.size());
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String buildUpdateStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("UPDATE ");
        builder.append(table);
        builder.append(" SET ");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWith(" = ?")).of(nonKeyColumns);
        if (!keyColumns.isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList().delimitedBy(" AND ").transformedBy(ExpressionBuilder.columnNamesWith(" = ?")).of(keyColumns);
        }
        return builder.toString();
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String buildDeleteStatement(TableId table, Collection<ColumnId> keyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("DELETE FROM ");
        builder.append(table);
        if (!keyColumns.isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList().delimitedBy(" AND ").transformedBy(ExpressionBuilder.columnNamesWith(" = ?")).of(keyColumns);
        }
        return builder.toString();
    }

    @Override
    public DatabaseDialect.StatementBinder statementBinder(PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, JdbcSinkConfig.InsertMode insertMode) {
        return new PreparedStatementBinder(this, statement, pkMode, schemaPair, fieldsMetadata, insertMode);
    }

    @Override
    public void bindField(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        if (value == null) {
            statement.setObject(index, null);
        } else {
            boolean bound = this.maybeBindLogical(statement, index, schema, value);
            if (!bound) {
                bound = this.maybeBindPrimitive(statement, index, schema, value);
            }
            if (!bound) {
                throw new ConnectException("Unsupported source data type: " + schema.type());
            }
        }
    }

    protected boolean maybeBindPrimitive(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        switch (schema.type()) {
            case INT8: {
                statement.setByte(index, (Byte)value);
                break;
            }
            case INT16: {
                statement.setShort(index, (Short)value);
                break;
            }
            case INT32: {
                statement.setInt(index, (Integer)value);
                break;
            }
            case INT64: {
                statement.setLong(index, (Long)value);
                break;
            }
            case FLOAT32: {
                statement.setFloat(index, ((Float)value).floatValue());
                break;
            }
            case FLOAT64: {
                statement.setDouble(index, (Double)value);
                break;
            }
            case BOOLEAN: {
                statement.setBoolean(index, (Boolean)value);
                break;
            }
            case STRING: {
                statement.setString(index, (String)value);
                break;
            }
            case BYTES: {
                byte[] bytes;
                if (value instanceof ByteBuffer) {
                    ByteBuffer buffer = ((ByteBuffer)value).slice();
                    bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                } else {
                    bytes = (byte[])value;
                }
                statement.setBytes(index, bytes);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean maybeBindLogical(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        if (schema.name() != null) {
            switch (schema.name()) {
                case "org.apache.kafka.connect.data.Date": {
                    statement.setDate(index, new java.sql.Date(((java.util.Date)value).getTime()), DateTimeUtils.getTimeZoneCalendar(this.timeZone));
                    return true;
                }
                case "org.apache.kafka.connect.data.Decimal": {
                    statement.setBigDecimal(index, (BigDecimal)value);
                    return true;
                }
                case "org.apache.kafka.connect.data.Time": {
                    statement.setTime(index, new java.sql.Time(((java.util.Date)value).getTime()), DateTimeUtils.getTimeZoneCalendar(this.timeZone));
                    return true;
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    statement.setTimestamp(index, new java.sql.Timestamp(((java.util.Date)value).getTime()), DateTimeUtils.getTimeZoneCalendar(this.timeZone));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public String buildCreateTableStatement(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        List<String> pkFieldNames = this.extractPrimaryKeyFieldNames(fields);
        builder.append("CREATE TABLE ");
        builder.append(table);
        builder.append(" (");
        this.writeColumnsSpec(builder, fields);
        if (!pkFieldNames.isEmpty()) {
            builder.append(",");
            builder.append(System.lineSeparator());
            builder.append("PRIMARY KEY(");
            builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.quote()).of(pkFieldNames);
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("DROP TABLE ");
        builder.append(table);
        if (options.ifExists()) {
            builder.append(" IF EXISTS");
        }
        if (options.cascade()) {
            builder.append(" CASCADE");
        }
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        boolean newlines = fields.size() > 1;
        ExpressionBuilder.Transform<SinkRecordField> transform = (builder, field) -> {
            if (newlines) {
                builder.appendNewLine();
            }
            builder.append("ADD ");
            this.writeColumnSpec(builder, (SinkRecordField)field);
        };
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("ALTER TABLE ");
        builder2.append(table);
        builder2.append(" ");
        builder2.appendList().delimitedBy(",").transformedBy(transform).of(fields);
        return Collections.singletonList(builder2.toString());
    }

    @Override
    public void validateSpecificColumnTypes(ResultSetMetaData rsMetadata, List<ColumnId> columns) throws ConnectException {
    }

    protected List<String> extractPrimaryKeyFieldNames(Collection<SinkRecordField> fields) {
        ArrayList<String> pks = new ArrayList<String>();
        for (SinkRecordField f : fields) {
            if (!f.isPrimaryKey()) continue;
            pks.add(f.name());
        }
        return pks;
    }

    protected void writeColumnsSpec(ExpressionBuilder builder, Collection<SinkRecordField> fields) {
        ExpressionBuilder.Transform<SinkRecordField> transform = (b, field) -> {
            b.append(System.lineSeparator());
            this.writeColumnSpec(b, (SinkRecordField)field);
        };
        builder.appendList().delimitedBy(",").transformedBy(transform).of(fields);
    }

    protected void writeColumnSpec(ExpressionBuilder builder, SinkRecordField f) {
        builder.appendColumnName(f.name());
        builder.append(" ");
        String sqlType = this.getSqlType(f);
        builder.append(sqlType);
        if (f.defaultValue() != null) {
            builder.append(" DEFAULT ");
            this.formatColumnValue(builder, f.schemaName(), f.schemaParameters(), f.schemaType(), f.defaultValue());
        } else if (this.isColumnOptional(f)) {
            builder.append(" NULL");
        } else {
            builder.append(" NOT NULL");
        }
    }

    protected boolean isColumnOptional(SinkRecordField field) {
        return field.isOptional();
    }

    protected void formatColumnValue(ExpressionBuilder builder, String schemaName, Map<String, String> schemaParameters, Schema.Type type, Object value) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    builder.append(value);
                    return;
                }
                case "org.apache.kafka.connect.data.Date": {
                    builder.appendStringQuoted(DateTimeUtils.formatDate((java.util.Date)value, this.timeZone));
                    return;
                }
                case "org.apache.kafka.connect.data.Time": {
                    builder.appendStringQuoted(DateTimeUtils.formatTime((java.util.Date)value, this.timeZone));
                    return;
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    builder.appendStringQuoted(DateTimeUtils.formatTimestamp((java.util.Date)value, this.timeZone));
                    return;
                }
            }
        }
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: {
                builder.append(value);
                break;
            }
            case BOOLEAN: {
                builder.append(Character.valueOf((Boolean)value != false ? (char)'1' : '0'));
                break;
            }
            case STRING: {
                builder.appendStringQuoted(value);
                break;
            }
            case BYTES: {
                byte[] bytes;
                if (value instanceof ByteBuffer) {
                    ByteBuffer buffer = ((ByteBuffer)value).slice();
                    bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                } else {
                    bytes = (byte[])value;
                }
                builder.appendBinaryLiteral(bytes);
                break;
            }
            default: {
                throw new ConnectException("Unsupported type for column value: " + type);
            }
        }
    }

    protected String getSqlType(SinkRecordField f) {
        throw new ConnectException(String.format("%s (%s) type doesn't have a mapping to the SQL database column type", f.schemaName(), f.schemaType()));
    }

    protected String sanitizedUrl(String url) {
        return url.replaceAll("(?i)([?&]([^=&]*)password([^=&]*)=)[^&]*", "$1****");
    }

    @Override
    public String identifier() {
        return this.name() + " database " + this.sanitizedUrl(this.jdbcUrl);
    }

    public String toString() {
        return this.name();
    }

    private static /* synthetic */ Object lambda$columnConverterFor$31(int col, ResultSet rs) throws SQLException, IOException {
        SQLXML xml = rs.getSQLXML(col);
        return xml != null ? xml.getString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object lambda$columnConverterFor$30(int col, boolean isJdbc4, ResultSet rs) throws SQLException, IOException {
        NClob clob = rs.getNClob(col);
        if (clob == null) {
            return null;
        }
        try {
            if (clob.length() > Integer.MAX_VALUE) {
                throw new IOException("Can't process NCLOBs longer than 2147483647");
            }
            String string = clob.getSubString(1L, (int)clob.length());
            return string;
        }
        finally {
            if (isJdbc4) {
                this.free(clob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object lambda$columnConverterFor$29(int col, boolean isJdbc4, ResultSet rs) throws SQLException, IOException {
        Clob clob = rs.getClob(col);
        if (clob == null) {
            return null;
        }
        try {
            if (clob.length() > Integer.MAX_VALUE) {
                throw new IOException("Can't process CLOBs longer than 2147483647");
            }
            String string = clob.getSubString(1L, (int)clob.length());
            return string;
        }
        finally {
            if (isJdbc4) {
                this.free(clob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object lambda$columnConverterFor$28(int col, boolean isJdbc4, ResultSet rs) throws SQLException, IOException {
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        try {
            if (blob.length() > Integer.MAX_VALUE) {
                throw new IOException("Can't process BLOBs longer than 2147483647");
            }
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            return byArray;
        }
        finally {
            if (isJdbc4) {
                this.free(blob);
            }
        }
    }

    private static /* synthetic */ Object lambda$columnConverterFor$27(int col, ResultSet rs) throws SQLException, IOException {
        URL url = rs.getURL(col);
        return url != null ? url.toString() : null;
    }

    private /* synthetic */ Object lambda$columnConverterFor$26(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getTimestamp(col, DateTimeUtils.getTimeZoneCalendar(this.timeZone));
    }

    private /* synthetic */ Object lambda$columnConverterFor$25(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getTime(col, DateTimeUtils.getTimeZoneCalendar(this.timeZone));
    }

    private static /* synthetic */ Object lambda$columnConverterFor$24(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getDate(col, DateTimeUtils.getTimeZoneCalendar(TimeZone.getTimeZone(ZoneOffset.UTC)));
    }

    private static /* synthetic */ Object lambda$columnConverterFor$23(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getBytes(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$22(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getNString(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$21(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getString(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$20(int col, int scale, ResultSet rs) throws SQLException, IOException {
        return rs.getBigDecimal(col, scale);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$19(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getDouble(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$18(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getByte(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$17(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getShort(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$16(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getInt(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$15(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getLong(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$14(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getByte(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$13(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getShort(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$12(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getInt(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$11(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getLong(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$10(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getDouble(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$9(int col, ResultSet rs) throws SQLException, IOException {
        return Float.valueOf(rs.getFloat(col));
    }

    private static /* synthetic */ Object lambda$columnConverterFor$8(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getLong(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$7(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getLong(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$6(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getInt(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$5(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getInt(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$4(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getShort(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$3(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getShort(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$2(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getByte(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$1(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getByte(col);
    }

    private static /* synthetic */ Object lambda$columnConverterFor$0(int col, ResultSet rs) throws SQLException, IOException {
        return rs.getBoolean(col);
    }

    public static class Provider
    extends DatabaseDialectProvider.FixedScoreProvider {
        public Provider() {
            super(GenericDatabaseDialect.class.getSimpleName(), 10);
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new GenericDatabaseDialect(config);
        }
    }
}

