/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.SchemaMapping;
import io.confluent.connect.jdbc.source.TableQuerier;
import io.confluent.connect.jdbc.source.TimestampIncrementingOffset;
import io.confluent.connect.jdbc.source.TimestampIncrementingTableQuerier;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTableQuerier
extends TimestampIncrementingTableQuerier {
    private static final Logger log = LoggerFactory.getLogger(TimestampTableQuerier.class);
    private boolean exhaustedResultSet;
    private PendingRecord nextRecord;
    private Timestamp latestCommittableTimestamp;

    public TimestampTableQuerier(DatabaseDialect dialect, TableQuerier.QueryMode mode, String name, String topicPrefix, List<String> timestampColumnNames, Map<String, Object> offsetMap, Long timestampDelay, TimeZone timeZone, String suffix) {
        super(dialect, mode, name, topicPrefix, timestampColumnNames, null, offsetMap, timestampDelay, timeZone, suffix);
        this.latestCommittableTimestamp = this.offset.getTimestampOffset();
        this.exhaustedResultSet = false;
        this.nextRecord = null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.exhaustedResultSet && this.nextRecord == null) {
            return false;
        }
        if (this.nextRecord == null) {
            if (this.resultSet.next()) {
                this.nextRecord = this.doExtractRecord();
            } else {
                this.exhaustedResultSet = true;
                return false;
            }
        }
        if (!this.resultSet.next()) {
            this.exhaustedResultSet = true;
        }
        return true;
    }

    @Override
    protected ResultSet executeQuery() throws SQLException {
        ResultSet result = super.executeQuery();
        this.exhaustedResultSet = false;
        return result;
    }

    @Override
    public SourceRecord extractRecord() {
        if (this.nextRecord == null) {
            throw new IllegalStateException("No more records are available");
        }
        PendingRecord currentRecord = this.nextRecord;
        PendingRecord pendingRecord = this.nextRecord = this.exhaustedResultSet ? null : this.doExtractRecord();
        if (this.nextRecord == null || this.canCommitTimestamp(currentRecord.timestamp(), this.nextRecord.timestamp())) {
            this.latestCommittableTimestamp = currentRecord.timestamp();
        }
        return currentRecord.record(this.latestCommittableTimestamp);
    }

    private PendingRecord doExtractRecord() {
        Struct record = new Struct(this.schemaMapping.schema());
        for (SchemaMapping.FieldSetter setter : this.schemaMapping.fieldSetters()) {
            try {
                setter.setField(record, this.resultSet);
            }
            catch (IOException e) {
                log.warn("Error mapping fields into Connect record", (Throwable)e);
                throw new ConnectException((Throwable)e);
            }
            catch (SQLException e) {
                log.warn("SQL error mapping fields into Connect record", (Throwable)e);
                throw new DataException((Throwable)e);
            }
        }
        this.offset = this.criteria.extractValues(this.schemaMapping.schema(), record, this.offset);
        Timestamp timestamp = this.offset.hasTimestampOffset() ? this.offset.getTimestampOffset() : null;
        return new PendingRecord(this.partition, timestamp, this.topic, record.schema(), record);
    }

    private boolean canCommitTimestamp(Timestamp current, Timestamp next) {
        return current == null || next == null || current.before(next);
    }

    @Override
    public void reset(long now, boolean resetOffset) {
        this.nextRecord = null;
        super.reset(now, resetOffset);
    }

    @Override
    public String toString() {
        return "TimestampTableQuerier{table=" + this.tableId + ", query='" + this.query + '\'' + ", topicPrefix='" + this.topicPrefix + '\'' + ", timestampColumns=" + this.timestampColumnNames + '}';
    }

    private static class PendingRecord {
        private final Map<String, String> partition;
        private final Timestamp timestamp;
        private final String topic;
        private final Schema valueSchema;
        private final Object value;

        public PendingRecord(Map<String, String> partition, Timestamp timestamp, String topic, Schema valueSchema, Object value) {
            this.partition = partition;
            this.timestamp = timestamp;
            this.topic = topic;
            this.valueSchema = valueSchema;
            this.value = value;
        }

        public Timestamp timestamp() {
            return this.timestamp;
        }

        public SourceRecord record(Timestamp offsetTimestamp) {
            TimestampIncrementingOffset offset = new TimestampIncrementingOffset(offsetTimestamp, null);
            return new SourceRecord(this.partition, offset.toMap(), this.topic, this.valueSchema, this.value);
        }
    }
}

