/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.apache.calcite.avatica.org.apache.http.HttpEntity;
import org.apache.calcite.avatica.org.apache.http.HttpHost;
import org.apache.calcite.avatica.org.apache.http.HttpRequestInterceptor;
import org.apache.calcite.avatica.org.apache.http.NoHttpResponseException;
import org.apache.calcite.avatica.org.apache.http.auth.AuthSchemeProvider;
import org.apache.calcite.avatica.org.apache.http.auth.AuthScope;
import org.apache.calcite.avatica.org.apache.http.auth.Credentials;
import org.apache.calcite.avatica.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.calcite.avatica.org.apache.http.client.AuthCache;
import org.apache.calcite.avatica.org.apache.http.client.ClientProtocolException;
import org.apache.calcite.avatica.org.apache.http.client.CredentialsProvider;
import org.apache.calcite.avatica.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.calcite.avatica.org.apache.http.client.methods.HttpPost;
import org.apache.calcite.avatica.org.apache.http.client.methods.HttpUriRequest;
import org.apache.calcite.avatica.org.apache.http.client.protocol.HttpClientContext;
import org.apache.calcite.avatica.org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.calcite.avatica.org.apache.http.config.Lookup;
import org.apache.calcite.avatica.org.apache.http.config.RegistryBuilder;
import org.apache.calcite.avatica.org.apache.http.conn.HttpClientConnectionManager;
import org.apache.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import org.apache.calcite.avatica.org.apache.http.entity.ContentType;
import org.apache.calcite.avatica.org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.calcite.avatica.org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.calcite.avatica.org.apache.http.impl.client.BasicAuthCache;
import org.apache.calcite.avatica.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.calcite.avatica.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.calcite.avatica.org.apache.http.impl.client.HttpClients;
import org.apache.calcite.avatica.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpContext;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessor;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpRequestExecutor;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestConnControl;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestContent;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestTargetHost;
import org.apache.calcite.avatica.org.apache.http.util.EntityUtils;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
UsernamePasswordAuthenticateable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "25";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "100";
    protected final HttpHost host;
    protected final URI uri;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestExecutor httpExecutor;
    protected final BasicAuthCache authCache;
    protected final CloseableHttpClient client;
    final PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeProvider> authRegistry = null;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.uri = AvaticaCommonsHttpClientImpl.toURI(Objects.requireNonNull(url));
        this.httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestExpectContinue()).build();
        this.httpExecutor = new HttpRequestExecutor();
        this.pool = new PoolingHttpClientConnectionManager();
        String maxCnxns = System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT);
        this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        String maxCnxnsPerRoute = System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT);
        this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.pool).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            HttpClientContext context = HttpClientContext.create();
            context.setTargetHost(this.host);
            if (null != this.credentials) {
                context.setCredentialsProvider(this.credentialsProvider);
                context.setAuthSchemeRegistry(this.authRegistry);
                context.setAuthCache((AuthCache)this.authCache);
            }
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity((HttpEntity)entity);
            try {
                CloseableHttpResponse response = this.execute(post, context);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (200 == statusCode || 500 == statusCode) {
                        byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                        return byArray;
                    }
                    if (503 == statusCode) {
                        LOG.debug("Failed to connect to server (HTTP/503), retrying");
                        continue;
                    }
                    throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    CloseableHttpResponse execute(HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.execute((HttpUriRequest)post, (HttpContext)context);
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
        RegistryBuilder authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", (Object)new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", (Object)new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

