/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive.schema;

import io.confluent.connect.storage.common.SchemaGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TimeBasedSchemaGenerator
implements SchemaGenerator<FieldSchema> {
    private final Map<String, Object> config;

    public TimeBasedSchemaGenerator() {
        this.config = new HashMap<String, Object>();
        this.config.put("hive.integration", false);
        this.config.put("directory.delim", "/");
    }

    public TimeBasedSchemaGenerator(Map<String, Object> config) {
        this.config = config == null ? Collections.emptyMap() : config;
    }

    public List<FieldSchema> newPartitionFields(String format) {
        Boolean hiveIntegration = (Boolean)this.config.get("hive.integration");
        hiveIntegration = hiveIntegration == null ? false : hiveIntegration;
        String delim = (String)this.config.get("directory.delim");
        String string = delim = delim == null ? "/" : delim;
        if (hiveIntegration.booleanValue() && !this.verifyDateTimeFormat(format, delim)) {
            throw new IllegalArgumentException("Path format doesn't meet the requirements for Hive integration, which require prefixing each DateTime component with its name.");
        }
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (String field : format.split(delim)) {
            String[] parts = field.split("=");
            FieldSchema fieldSchema = new FieldSchema(parts[0].replace("'", ""), TypeInfoFactory.stringTypeInfo.toString(), "");
            fields.add(fieldSchema);
        }
        return fields;
    }

    private boolean verifyDateTimeFormat(String pathFormat, String delim) {
        String extendedPathFormat = pathFormat.endsWith(delim) ? pathFormat : pathFormat + delim;
        String patternString = "'year'=Y{1,5}" + delim + "('month'=M{1,5}" + delim + ")?('day'=d{1,3}" + delim + ")?('hour'=H{1,3}" + delim + ")?('minute'=m{1,3}" + delim + ")?";
        return Pattern.compile(patternString).matcher(extendedPathFormat).matches();
    }
}

