/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive;

import io.confluent.connect.storage.errors.HiveMetaStoreException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStore {
    private static final Logger log = LoggerFactory.getLogger(HiveMetaStore.class);
    protected final IMetaStoreClient client;

    public HiveMetaStore(AbstractConfig connectorConfig) {
        this(new Configuration(), connectorConfig);
    }

    public HiveMetaStore(Configuration conf, AbstractConfig connectorConfig) throws HiveMetaStoreException {
        HiveConf hiveConf = new HiveConf(conf, HiveConf.class);
        String hiveConfDir = connectorConfig.getString("hive.conf.dir");
        String hiveMetaStoreUris = connectorConfig.getString("hive.metastore.uris");
        if (hiveMetaStoreUris.isEmpty()) {
            log.warn("hive.metastore.uris empty, an embedded Hive metastore will be created in the directory the connector is started. You need to start Hive in that specific directory to query the data.");
        }
        if (!hiveConfDir.equals("")) {
            String hiveSitePath = hiveConfDir + "/hive-site.xml";
            File hiveSite = new File(hiveSitePath);
            if (!hiveSite.exists()) {
                log.warn("hive-site.xml does not exist in provided Hive configuration directory {}.", (Object)hiveConf);
            }
            hiveConf.addResource(new Path(hiveSitePath));
        }
        hiveConf.set("hive.metastore.uris", hiveMetaStoreUris);
        try {
            this.client = HCatUtil.getHiveMetastoreClient((HiveConf)hiveConf);
        }
        catch (IOException | MetaException e) {
            throw new HiveMetaStoreException(e);
        }
    }

    private <R> R doAction(ClientAction<R> action) throws HiveMetaStoreException {
        try {
            return action.call();
        }
        catch (MetaException e) {
            throw new HiveMetaStoreException("Hive MetaStore exception", e);
        }
        catch (TException e) {
            throw new HiveMetaStoreException("Exception communicating with the Hive MetaStore", e);
        }
    }

    public void addPartition(final String database, final String tableName, final String path) throws HiveMetaStoreException {
        ClientAction<Void> addPartition = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.appendPartition(database, HiveMetaStore.this.tableNameConverter(tableName), path);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                }
                catch (InvalidObjectException e) {
                    throw new HiveMetaStoreException("Invalid partition for " + database + "." + HiveMetaStore.this.tableNameConverter(tableName) + ": " + path, e);
                }
                return null;
            }
        };
        this.doAction(addPartition);
    }

    public void dropPartition(final String database, final String tableName, final String path) throws HiveMetaStoreException {
        ClientAction<Void> dropPartition = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.dropPartition(database, HiveMetaStore.this.tableNameConverter(tableName), path, false);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (InvalidObjectException e) {
                    throw new HiveMetaStoreException("Invalid partition for " + database + "." + HiveMetaStore.this.tableNameConverter(tableName) + ": " + path, e);
                }
                return null;
            }
        };
        this.doAction(dropPartition);
    }

    public void createDatabase(final String database) throws HiveMetaStoreException {
        ClientAction<Void> create = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.createDatabase(new Database(database, "Database created by Kafka Connect", null, null));
                }
                catch (AlreadyExistsException e) {
                    log.warn("Hive database already exists: {}", (Object)database);
                }
                catch (InvalidObjectException e) {
                    throw new HiveMetaStoreException("Invalid database: " + database, e);
                }
                return null;
            }
        };
        this.doAction(create);
    }

    public void dropDatabase(final String name, final boolean deleteData) throws HiveMetaStoreException {
        ClientAction<Void> drop = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.dropDatabase(name, deleteData, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.doAction(drop);
    }

    public void createTable(final Table table) throws HiveMetaStoreException {
        ClientAction<Void> create = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.createTable(table.getTTable());
                }
                catch (NoSuchObjectException e) {
                    throw new HiveMetaStoreException("Hive table not found: " + table.getDbName() + "." + table.getTableName());
                }
                catch (AlreadyExistsException e) {
                    log.warn("Hive table already exists: {}.{}", (Object)table.getDbName(), (Object)table.getTableName());
                }
                catch (InvalidObjectException e) {
                    throw new HiveMetaStoreException("Invalid table", e);
                }
                return null;
            }
        };
        this.createDatabase(table.getDbName());
        this.doAction(create);
    }

    public void alterTable(final Table table, final boolean cascade) throws HiveMetaStoreException {
        ClientAction<Void> alter = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.alter_table(table.getDbName(), table.getTableName(), table.getTTable(), cascade);
                }
                catch (NoSuchObjectException e) {
                    throw new HiveMetaStoreException("Hive table not found: " + table.getDbName() + "." + table.getTableName());
                }
                catch (InvalidObjectException e) {
                    throw new HiveMetaStoreException("Invalid table", e);
                }
                catch (InvalidOperationException e) {
                    throw new HiveMetaStoreException("Invalid table change", e);
                }
                return null;
            }
        };
        this.doAction(alter);
    }

    public void alterTable(Table table) throws HiveMetaStoreException {
        this.alterTable(table, false);
    }

    public void dropTable(final String database, final String tableName) {
        ClientAction<Void> drop = new ClientAction<Void>(){

            @Override
            public Void call() throws TException {
                try {
                    HiveMetaStore.this.client.dropTable(database, HiveMetaStore.this.tableNameConverter(tableName), false, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.doAction(drop);
    }

    public boolean tableExists(final String database, final String tableName) throws HiveMetaStoreException {
        ClientAction<Boolean> exists = new ClientAction<Boolean>(){

            @Override
            public Boolean call() throws TException {
                try {
                    return HiveMetaStore.this.client.tableExists(database, HiveMetaStore.this.tableNameConverter(tableName));
                }
                catch (UnknownDBException e) {
                    return false;
                }
            }
        };
        return this.doAction(exists);
    }

    public Table getTable(final String database, final String tableName) throws HiveMetaStoreException {
        ClientAction<Table> getTable = new ClientAction<Table>(){

            @Override
            public Table call() throws TException {
                try {
                    return new Table(HiveMetaStore.this.client.getTable(database, HiveMetaStore.this.tableNameConverter(tableName)));
                }
                catch (NoSuchObjectException e) {
                    throw new HiveMetaStoreException("Hive table not found: " + database + "." + HiveMetaStore.this.tableNameConverter(tableName));
                }
            }
        };
        Table table = this.doAction(getTable);
        if (table == null) {
            throw new HiveMetaStoreException("Could not find info for table: " + this.tableNameConverter(tableName));
        }
        return table;
    }

    public List<String> listPartitions(final String database, final String tableName, final short max) throws HiveMetaStoreException {
        ClientAction<List<String>> listPartitions = new ClientAction<List<String>>(){

            @Override
            public List<String> call() throws TException {
                try {
                    List partitions = HiveMetaStore.this.client.listPartitions(database, HiveMetaStore.this.tableNameConverter(tableName), max);
                    ArrayList<String> paths = new ArrayList<String>();
                    for (Partition partition : partitions) {
                        paths.add(partition.getSd().getLocation());
                    }
                    return paths;
                }
                catch (NoSuchObjectException e) {
                    return new ArrayList<String>();
                }
            }
        };
        return this.doAction(listPartitions);
    }

    public List<String> getAllTables(final String database) throws HiveMetaStoreException {
        ClientAction<List<String>> getAllTables = new ClientAction<List<String>>(){

            @Override
            public List<String> call() throws TException {
                try {
                    return HiveMetaStore.this.client.getAllTables(database);
                }
                catch (NoSuchObjectException e) {
                    return new ArrayList<String>();
                }
            }
        };
        return this.doAction(getAllTables);
    }

    public List<String> getAllDatabases() throws HiveMetaStoreException {
        ClientAction<List<String>> create = new ClientAction<List<String>>(){

            @Override
            public List<String> call() throws TException {
                try {
                    return HiveMetaStore.this.client.getAllDatabases();
                }
                catch (NoSuchObjectException e) {
                    return new ArrayList<String>();
                }
            }
        };
        return this.doAction(create);
    }

    public String tableNameConverter(String table) {
        return table == null ? table : table.replaceAll("[.-]", "_");
    }

    private static interface ClientAction<R> {
        public R call() throws TException;
    }
}

