/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class HiveSchemaConverter {
    private static final Map<Schema.Type, TypeInfo> TYPE_TO_TYPEINFO = new HashMap<Schema.Type, TypeInfo>();

    public static List<FieldSchema> convertSchema(Schema schema) {
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        if (Schema.Type.STRUCT.equals((Object)schema.type())) {
            for (Field field : schema.fields()) {
                columns.add(new FieldSchema(field.name(), HiveSchemaConverter.convert(field.schema()).getTypeName(), field.schema().doc()));
            }
        }
        return columns;
    }

    public static TypeInfo convert(Schema schema) {
        switch (schema.type()) {
            case STRUCT: {
                return HiveSchemaConverter.convertStruct(schema);
            }
            case ARRAY: {
                return HiveSchemaConverter.convertArray(schema);
            }
            case MAP: {
                return HiveSchemaConverter.convertMap(schema);
            }
        }
        return HiveSchemaConverter.convertPrimitive(schema);
    }

    public static TypeInfo convertStruct(Schema schema) {
        List fields = schema.fields();
        ArrayList<String> names = new ArrayList<String>(fields.size());
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(fields.size());
        for (Field field : fields) {
            names.add(field.name());
            types.add(HiveSchemaConverter.convert(field.schema()));
        }
        return TypeInfoFactory.getStructTypeInfo(names, types);
    }

    public static TypeInfo convertArray(Schema schema) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveSchemaConverter.convert(schema.valueSchema()));
    }

    public static TypeInfo convertMap(Schema schema) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveSchemaConverter.convert(schema.keySchema()), (TypeInfo)HiveSchemaConverter.convert(schema.valueSchema()));
    }

    public static TypeInfo convertPrimitive(Schema schema) {
        return TYPE_TO_TYPEINFO.get(schema.type());
    }

    static {
        TYPE_TO_TYPEINFO.put(Schema.Type.BOOLEAN, (TypeInfo)TypeInfoFactory.booleanTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT8, (TypeInfo)TypeInfoFactory.byteTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT16, (TypeInfo)TypeInfoFactory.shortTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT32, (TypeInfo)TypeInfoFactory.intTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT64, (TypeInfo)TypeInfoFactory.longTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.FLOAT32, (TypeInfo)TypeInfoFactory.floatTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.FLOAT64, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.BYTES, (TypeInfo)TypeInfoFactory.binaryTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.STRING, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }
}

