/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive;

import io.confluent.connect.storage.hive.HiveMetaStore;
import io.confluent.connect.storage.partitioner.Partitioner;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;

public abstract class HiveUtil {
    protected String url;
    protected final HiveMetaStore hiveMetaStore;
    protected final String delim;

    public HiveUtil(AbstractConfig connectorConfig, HiveMetaStore hiveMetaStore) {
        this.url = connectorConfig.getString("store.url");
        this.hiveMetaStore = hiveMetaStore;
        this.delim = connectorConfig.getString("directory.delim");
    }

    public abstract void createTable(String var1, String var2, Schema var3, Partitioner<FieldSchema> var4);

    public abstract void alterSchema(String var1, String var2, Schema var3);

    public Table newTable(String database, String table) {
        return new Table(database, this.hiveMetaStore.tableNameConverter(table));
    }

    public String hiveDirectoryName(String url, String topicsDir, String topic) {
        return url + this.delim + topicsDir + this.delim + topic + this.delim;
    }
}

