/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive;

import io.confluent.connect.storage.common.ComposableConfig;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class HiveConfig
extends AbstractConfig
implements ComposableConfig {
    public static final String HIVE_INTEGRATION_CONFIG = "hive.integration";
    public static final String HIVE_INTEGRATION_DOC = "Configuration indicating whether to integrate with Hive when running the connector.";
    public static final boolean HIVE_INTEGRATION_DEFAULT = false;
    public static final String HIVE_INTEGRATION_DISPLAY = "Hive Integration";
    public static final String HIVE_METASTORE_URIS_CONFIG = "hive.metastore.uris";
    public static final String HIVE_METASTORE_URIS_DOC = "The Hive metastore URIs, can be IP address or fully-qualified domain name and port of the metastore host.";
    public static final String HIVE_METASTORE_URIS_DEFAULT = "";
    public static final String HIVE_METASTORE_URIS_DISPLAY = "Hive Metastore URIs";
    public static final String HIVE_CONF_DIR_CONFIG = "hive.conf.dir";
    public static final String HIVE_CONF_DIR_DOC = "Hive configuration directory";
    public static final String HIVE_CONF_DIR_DEFAULT = "";
    public static final String HIVE_CONF_DIR_DISPLAY = "Hive configuration directory.";
    public static final String HIVE_HOME_CONFIG = "hive.home";
    public static final String HIVE_HOME_DOC = "Hive home directory.";
    public static final String HIVE_HOME_DEFAULT = "";
    public static final String HIVE_HOME_DISPLAY = "Hive home directory";
    public static final String HIVE_DATABASE_CONFIG = "hive.database";
    public static final String HIVE_DATABASE_DOC = "The database to use when the connector creates tables in Hive.";
    public static final String HIVE_DATABASE_DEFAULT = "default";
    public static final String HIVE_DATABASE_DISPLAY = "Hive database";
    public static final ConfigDef.Recommender hiveIntegrationDependentsRecommender = new BooleanParentRecommender("hive.integration");
    protected static final ConfigDef CONFIG_DEF = new ConfigDef();

    public Object get(String key) {
        return super.get(key);
    }

    public static ConfigDef getConfig() {
        return CONFIG_DEF;
    }

    public HiveConfig(Map<String, String> props) {
        super(CONFIG_DEF, props);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG_DEF.toRst());
    }

    static {
        String group = "Hive";
        int orderInGroup = 0;
        CONFIG_DEF.define(HIVE_INTEGRATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, HIVE_INTEGRATION_DOC, "Hive", ++orderInGroup, ConfigDef.Width.SHORT, HIVE_INTEGRATION_DISPLAY, Arrays.asList(HIVE_METASTORE_URIS_CONFIG, HIVE_CONF_DIR_CONFIG, HIVE_HOME_CONFIG, HIVE_DATABASE_CONFIG));
        CONFIG_DEF.define(HIVE_METASTORE_URIS_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HIVE_METASTORE_URIS_DOC, "Hive", ++orderInGroup, ConfigDef.Width.MEDIUM, HIVE_METASTORE_URIS_DISPLAY, hiveIntegrationDependentsRecommender);
        CONFIG_DEF.define(HIVE_CONF_DIR_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HIVE_CONF_DIR_DOC, "Hive", ++orderInGroup, ConfigDef.Width.MEDIUM, HIVE_CONF_DIR_DISPLAY, hiveIntegrationDependentsRecommender);
        CONFIG_DEF.define(HIVE_HOME_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HIVE_HOME_DOC, "Hive", ++orderInGroup, ConfigDef.Width.MEDIUM, HIVE_HOME_DISPLAY, hiveIntegrationDependentsRecommender);
        CONFIG_DEF.define(HIVE_DATABASE_CONFIG, ConfigDef.Type.STRING, (Object)HIVE_DATABASE_DEFAULT, ConfigDef.Importance.HIGH, HIVE_DATABASE_DOC, "Hive", ++orderInGroup, ConfigDef.Width.SHORT, HIVE_DATABASE_DISPLAY, hiveIntegrationDependentsRecommender);
    }

    public static class BooleanParentRecommender
    implements ConfigDef.Recommender {
        protected final String parentConfigName;

        public BooleanParentRecommender(String parentConfigName) {
            this.parentConfigName = parentConfigName;
        }

        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            return new LinkedList<Object>();
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return (Boolean)connectorConfigs.get(this.parentConfigName);
        }
    }
}

