/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.errors.PartitionException;
import io.confluent.connect.storage.partitioner.DefaultPartitioner;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldPartitioner<T>
extends DefaultPartitioner<T> {
    private static final Logger log = LoggerFactory.getLogger(FieldPartitioner.class);
    private List<String> fieldNames;

    @Override
    public void configure(Map<String, Object> config) {
        this.fieldNames = (List)config.get("partition.field.name");
        this.delim = (String)config.get("directory.delim");
    }

    @Override
    public String encodePartition(SinkRecord sinkRecord) {
        Object value = sinkRecord.value();
        if (value instanceof Struct) {
            Schema valueSchema = sinkRecord.valueSchema();
            Struct struct = (Struct)value;
            StringBuilder builder = new StringBuilder();
            block5: for (String fieldName : this.fieldNames) {
                if (builder.length() > 0) {
                    builder.append(this.delim);
                }
                Object partitionKey = struct.get(fieldName);
                Schema.Type type = valueSchema.field(fieldName).schema().type();
                switch (type) {
                    case INT8: 
                    case INT16: 
                    case INT32: 
                    case INT64: {
                        Number record = (Number)partitionKey;
                        builder.append(fieldName + "=" + record.toString());
                        continue block5;
                    }
                    case STRING: {
                        builder.append(fieldName + "=" + (String)partitionKey);
                        continue block5;
                    }
                    case BOOLEAN: {
                        boolean booleanRecord = (Boolean)partitionKey;
                        builder.append(fieldName + "=" + Boolean.toString(booleanRecord));
                        continue block5;
                    }
                }
                log.error("Type {} is not supported as a partition key.", (Object)type.getName());
                throw new PartitionException("Error encoding partition.");
            }
            return builder.toString();
        }
        log.error("Value is not Struct type.");
        throw new PartitionException("Error encoding partition.");
    }

    @Override
    public List<T> partitionFields() {
        if (this.partitionFields == null) {
            this.partitionFields = this.newSchemaGenerator(this.config).newPartitionFields(Utils.join(this.fieldNames, (String)","));
        }
        return this.partitionFields;
    }
}

